/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AlternativeSecurityId;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.Extension;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Device
extends DirectoryObject
implements Parsable {
    public Device() {
        this.setOdataType("#microsoft.graph.device");
    }

    @Nonnull
    public static Device createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Device();
    }

    @Nullable
    public Boolean getAccountEnabled() {
        return (Boolean)this.backingStore.get("accountEnabled");
    }

    @Nullable
    public List<AlternativeSecurityId> getAlternativeSecurityIds() {
        return (List)this.backingStore.get("alternativeSecurityIds");
    }

    @Nullable
    public OffsetDateTime getApproximateLastSignInDateTime() {
        return (OffsetDateTime)this.backingStore.get("approximateLastSignInDateTime");
    }

    @Nullable
    public OffsetDateTime getComplianceExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("complianceExpirationDateTime");
    }

    @Nullable
    public String getDeviceCategory() {
        return (String)this.backingStore.get("deviceCategory");
    }

    @Nullable
    public String getDeviceId() {
        return (String)this.backingStore.get("deviceId");
    }

    @Nullable
    public String getDeviceMetadata() {
        return (String)this.backingStore.get("deviceMetadata");
    }

    @Nullable
    public String getDeviceOwnership() {
        return (String)this.backingStore.get("deviceOwnership");
    }

    @Nullable
    public Integer getDeviceVersion() {
        return (Integer)this.backingStore.get("deviceVersion");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public String getEnrollmentProfileName() {
        return (String)this.backingStore.get("enrollmentProfileName");
    }

    @Nullable
    public String getEnrollmentType() {
        return (String)this.backingStore.get("enrollmentType");
    }

    @Nullable
    public List<Extension> getExtensions() {
        return (List)this.backingStore.get("extensions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("accountEnabled", n -> this.setAccountEnabled(n.getBooleanValue()));
        deserializerMap.put("alternativeSecurityIds", n -> this.setAlternativeSecurityIds(n.getCollectionOfObjectValues(AlternativeSecurityId::createFromDiscriminatorValue)));
        deserializerMap.put("approximateLastSignInDateTime", n -> this.setApproximateLastSignInDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("complianceExpirationDateTime", n -> this.setComplianceExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("deviceCategory", n -> this.setDeviceCategory(n.getStringValue()));
        deserializerMap.put("deviceId", n -> this.setDeviceId(n.getStringValue()));
        deserializerMap.put("deviceMetadata", n -> this.setDeviceMetadata(n.getStringValue()));
        deserializerMap.put("deviceOwnership", n -> this.setDeviceOwnership(n.getStringValue()));
        deserializerMap.put("deviceVersion", n -> this.setDeviceVersion(n.getIntegerValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("enrollmentProfileName", n -> this.setEnrollmentProfileName(n.getStringValue()));
        deserializerMap.put("enrollmentType", n -> this.setEnrollmentType(n.getStringValue()));
        deserializerMap.put("extensions", n -> this.setExtensions(n.getCollectionOfObjectValues(Extension::createFromDiscriminatorValue)));
        deserializerMap.put("isCompliant", n -> this.setIsCompliant(n.getBooleanValue()));
        deserializerMap.put("isManaged", n -> this.setIsManaged(n.getBooleanValue()));
        deserializerMap.put("isRooted", n -> this.setIsRooted(n.getBooleanValue()));
        deserializerMap.put("managementType", n -> this.setManagementType(n.getStringValue()));
        deserializerMap.put("manufacturer", n -> this.setManufacturer(n.getStringValue()));
        deserializerMap.put("mdmAppId", n -> this.setMdmAppId(n.getStringValue()));
        deserializerMap.put("memberOf", n -> this.setMemberOf(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("model", n -> this.setModel(n.getStringValue()));
        deserializerMap.put("onPremisesLastSyncDateTime", n -> this.setOnPremisesLastSyncDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("onPremisesSecurityIdentifier", n -> this.setOnPremisesSecurityIdentifier(n.getStringValue()));
        deserializerMap.put("onPremisesSyncEnabled", n -> this.setOnPremisesSyncEnabled(n.getBooleanValue()));
        deserializerMap.put("operatingSystem", n -> this.setOperatingSystem(n.getStringValue()));
        deserializerMap.put("operatingSystemVersion", n -> this.setOperatingSystemVersion(n.getStringValue()));
        deserializerMap.put("physicalIds", n -> this.setPhysicalIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("profileType", n -> this.setProfileType(n.getStringValue()));
        deserializerMap.put("registeredOwners", n -> this.setRegisteredOwners(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("registeredUsers", n -> this.setRegisteredUsers(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("registrationDateTime", n -> this.setRegistrationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("systemLabels", n -> this.setSystemLabels(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("transitiveMemberOf", n -> this.setTransitiveMemberOf(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("trustType", n -> this.setTrustType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsCompliant() {
        return (Boolean)this.backingStore.get("isCompliant");
    }

    @Nullable
    public Boolean getIsManaged() {
        return (Boolean)this.backingStore.get("isManaged");
    }

    @Nullable
    public Boolean getIsRooted() {
        return (Boolean)this.backingStore.get("isRooted");
    }

    @Nullable
    public String getManagementType() {
        return (String)this.backingStore.get("managementType");
    }

    @Nullable
    public String getManufacturer() {
        return (String)this.backingStore.get("manufacturer");
    }

    @Nullable
    public String getMdmAppId() {
        return (String)this.backingStore.get("mdmAppId");
    }

    @Nullable
    public List<DirectoryObject> getMemberOf() {
        return (List)this.backingStore.get("memberOf");
    }

    @Nullable
    public String getModel() {
        return (String)this.backingStore.get("model");
    }

    @Nullable
    public OffsetDateTime getOnPremisesLastSyncDateTime() {
        return (OffsetDateTime)this.backingStore.get("onPremisesLastSyncDateTime");
    }

    @Nullable
    public String getOnPremisesSecurityIdentifier() {
        return (String)this.backingStore.get("onPremisesSecurityIdentifier");
    }

    @Nullable
    public Boolean getOnPremisesSyncEnabled() {
        return (Boolean)this.backingStore.get("onPremisesSyncEnabled");
    }

    @Nullable
    public String getOperatingSystem() {
        return (String)this.backingStore.get("operatingSystem");
    }

    @Nullable
    public String getOperatingSystemVersion() {
        return (String)this.backingStore.get("operatingSystemVersion");
    }

    @Nullable
    public List<String> getPhysicalIds() {
        return (List)this.backingStore.get("physicalIds");
    }

    @Nullable
    public String getProfileType() {
        return (String)this.backingStore.get("profileType");
    }

    @Nullable
    public List<DirectoryObject> getRegisteredOwners() {
        return (List)this.backingStore.get("registeredOwners");
    }

    @Nullable
    public List<DirectoryObject> getRegisteredUsers() {
        return (List)this.backingStore.get("registeredUsers");
    }

    @Nullable
    public OffsetDateTime getRegistrationDateTime() {
        return (OffsetDateTime)this.backingStore.get("registrationDateTime");
    }

    @Nullable
    public List<String> getSystemLabels() {
        return (List)this.backingStore.get("systemLabels");
    }

    @Nullable
    public List<DirectoryObject> getTransitiveMemberOf() {
        return (List)this.backingStore.get("transitiveMemberOf");
    }

    @Nullable
    public String getTrustType() {
        return (String)this.backingStore.get("trustType");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("accountEnabled", this.getAccountEnabled());
        writer.writeCollectionOfObjectValues("alternativeSecurityIds", this.getAlternativeSecurityIds());
        writer.writeOffsetDateTimeValue("approximateLastSignInDateTime", this.getApproximateLastSignInDateTime());
        writer.writeOffsetDateTimeValue("complianceExpirationDateTime", this.getComplianceExpirationDateTime());
        writer.writeStringValue("deviceCategory", this.getDeviceCategory());
        writer.writeStringValue("deviceId", this.getDeviceId());
        writer.writeStringValue("deviceMetadata", this.getDeviceMetadata());
        writer.writeStringValue("deviceOwnership", this.getDeviceOwnership());
        writer.writeIntegerValue("deviceVersion", this.getDeviceVersion());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("enrollmentProfileName", this.getEnrollmentProfileName());
        writer.writeStringValue("enrollmentType", this.getEnrollmentType());
        writer.writeCollectionOfObjectValues("extensions", this.getExtensions());
        writer.writeBooleanValue("isCompliant", this.getIsCompliant());
        writer.writeBooleanValue("isManaged", this.getIsManaged());
        writer.writeBooleanValue("isRooted", this.getIsRooted());
        writer.writeStringValue("managementType", this.getManagementType());
        writer.writeStringValue("manufacturer", this.getManufacturer());
        writer.writeStringValue("mdmAppId", this.getMdmAppId());
        writer.writeCollectionOfObjectValues("memberOf", this.getMemberOf());
        writer.writeStringValue("model", this.getModel());
        writer.writeOffsetDateTimeValue("onPremisesLastSyncDateTime", this.getOnPremisesLastSyncDateTime());
        writer.writeStringValue("onPremisesSecurityIdentifier", this.getOnPremisesSecurityIdentifier());
        writer.writeBooleanValue("onPremisesSyncEnabled", this.getOnPremisesSyncEnabled());
        writer.writeStringValue("operatingSystem", this.getOperatingSystem());
        writer.writeStringValue("operatingSystemVersion", this.getOperatingSystemVersion());
        writer.writeCollectionOfPrimitiveValues("physicalIds", this.getPhysicalIds());
        writer.writeStringValue("profileType", this.getProfileType());
        writer.writeCollectionOfObjectValues("registeredOwners", this.getRegisteredOwners());
        writer.writeCollectionOfObjectValues("registeredUsers", this.getRegisteredUsers());
        writer.writeOffsetDateTimeValue("registrationDateTime", this.getRegistrationDateTime());
        writer.writeCollectionOfPrimitiveValues("systemLabels", this.getSystemLabels());
        writer.writeCollectionOfObjectValues("transitiveMemberOf", this.getTransitiveMemberOf());
        writer.writeStringValue("trustType", this.getTrustType());
    }

    public void setAccountEnabled(@Nullable Boolean value) {
        this.backingStore.set("accountEnabled", (Object)value);
    }

    public void setAlternativeSecurityIds(@Nullable List<AlternativeSecurityId> value) {
        this.backingStore.set("alternativeSecurityIds", value);
    }

    public void setApproximateLastSignInDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("approximateLastSignInDateTime", (Object)value);
    }

    public void setComplianceExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("complianceExpirationDateTime", (Object)value);
    }

    public void setDeviceCategory(@Nullable String value) {
        this.backingStore.set("deviceCategory", (Object)value);
    }

    public void setDeviceId(@Nullable String value) {
        this.backingStore.set("deviceId", (Object)value);
    }

    public void setDeviceMetadata(@Nullable String value) {
        this.backingStore.set("deviceMetadata", (Object)value);
    }

    public void setDeviceOwnership(@Nullable String value) {
        this.backingStore.set("deviceOwnership", (Object)value);
    }

    public void setDeviceVersion(@Nullable Integer value) {
        this.backingStore.set("deviceVersion", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEnrollmentProfileName(@Nullable String value) {
        this.backingStore.set("enrollmentProfileName", (Object)value);
    }

    public void setEnrollmentType(@Nullable String value) {
        this.backingStore.set("enrollmentType", (Object)value);
    }

    public void setExtensions(@Nullable List<Extension> value) {
        this.backingStore.set("extensions", value);
    }

    public void setIsCompliant(@Nullable Boolean value) {
        this.backingStore.set("isCompliant", (Object)value);
    }

    public void setIsManaged(@Nullable Boolean value) {
        this.backingStore.set("isManaged", (Object)value);
    }

    public void setIsRooted(@Nullable Boolean value) {
        this.backingStore.set("isRooted", (Object)value);
    }

    public void setManagementType(@Nullable String value) {
        this.backingStore.set("managementType", (Object)value);
    }

    public void setManufacturer(@Nullable String value) {
        this.backingStore.set("manufacturer", (Object)value);
    }

    public void setMdmAppId(@Nullable String value) {
        this.backingStore.set("mdmAppId", (Object)value);
    }

    public void setMemberOf(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("memberOf", value);
    }

    public void setModel(@Nullable String value) {
        this.backingStore.set("model", (Object)value);
    }

    public void setOnPremisesLastSyncDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("onPremisesLastSyncDateTime", (Object)value);
    }

    public void setOnPremisesSecurityIdentifier(@Nullable String value) {
        this.backingStore.set("onPremisesSecurityIdentifier", (Object)value);
    }

    public void setOnPremisesSyncEnabled(@Nullable Boolean value) {
        this.backingStore.set("onPremisesSyncEnabled", (Object)value);
    }

    public void setOperatingSystem(@Nullable String value) {
        this.backingStore.set("operatingSystem", (Object)value);
    }

    public void setOperatingSystemVersion(@Nullable String value) {
        this.backingStore.set("operatingSystemVersion", (Object)value);
    }

    public void setPhysicalIds(@Nullable List<String> value) {
        this.backingStore.set("physicalIds", value);
    }

    public void setProfileType(@Nullable String value) {
        this.backingStore.set("profileType", (Object)value);
    }

    public void setRegisteredOwners(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("registeredOwners", value);
    }

    public void setRegisteredUsers(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("registeredUsers", value);
    }

    public void setRegistrationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("registrationDateTime", (Object)value);
    }

    public void setSystemLabels(@Nullable List<String> value) {
        this.backingStore.set("systemLabels", value);
    }

    public void setTransitiveMemberOf(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("transitiveMemberOf", value);
    }

    public void setTrustType(@Nullable String value) {
        this.backingStore.set("trustType", (Object)value);
    }
}

