/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AndroidCustomConfiguration;
import com.microsoft.graph.models.AndroidGeneralDeviceConfiguration;
import com.microsoft.graph.models.AndroidWorkProfileCustomConfiguration;
import com.microsoft.graph.models.AndroidWorkProfileGeneralDeviceConfiguration;
import com.microsoft.graph.models.AppleDeviceFeaturesConfigurationBase;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import com.microsoft.graph.models.DeviceConfigurationDeviceOverview;
import com.microsoft.graph.models.DeviceConfigurationDeviceStatus;
import com.microsoft.graph.models.DeviceConfigurationUserOverview;
import com.microsoft.graph.models.DeviceConfigurationUserStatus;
import com.microsoft.graph.models.EditionUpgradeConfiguration;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IosCertificateProfile;
import com.microsoft.graph.models.IosCustomConfiguration;
import com.microsoft.graph.models.IosDeviceFeaturesConfiguration;
import com.microsoft.graph.models.IosGeneralDeviceConfiguration;
import com.microsoft.graph.models.IosUpdateConfiguration;
import com.microsoft.graph.models.MacOSCustomConfiguration;
import com.microsoft.graph.models.MacOSDeviceFeaturesConfiguration;
import com.microsoft.graph.models.MacOSGeneralDeviceConfiguration;
import com.microsoft.graph.models.SettingStateDeviceSummary;
import com.microsoft.graph.models.SharedPCConfiguration;
import com.microsoft.graph.models.Windows10CustomConfiguration;
import com.microsoft.graph.models.Windows10EndpointProtectionConfiguration;
import com.microsoft.graph.models.Windows10EnterpriseModernAppManagementConfiguration;
import com.microsoft.graph.models.Windows10GeneralConfiguration;
import com.microsoft.graph.models.Windows10SecureAssessmentConfiguration;
import com.microsoft.graph.models.Windows10TeamGeneralConfiguration;
import com.microsoft.graph.models.Windows81GeneralConfiguration;
import com.microsoft.graph.models.WindowsDefenderAdvancedThreatProtectionConfiguration;
import com.microsoft.graph.models.WindowsPhone81CustomConfiguration;
import com.microsoft.graph.models.WindowsPhone81GeneralConfiguration;
import com.microsoft.graph.models.WindowsUpdateForBusinessConfiguration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceConfiguration
extends Entity
implements Parsable {
    @Nonnull
    public static DeviceConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.androidCustomConfiguration": {
                    return new AndroidCustomConfiguration();
                }
                case "#microsoft.graph.androidGeneralDeviceConfiguration": {
                    return new AndroidGeneralDeviceConfiguration();
                }
                case "#microsoft.graph.androidWorkProfileCustomConfiguration": {
                    return new AndroidWorkProfileCustomConfiguration();
                }
                case "#microsoft.graph.androidWorkProfileGeneralDeviceConfiguration": {
                    return new AndroidWorkProfileGeneralDeviceConfiguration();
                }
                case "#microsoft.graph.appleDeviceFeaturesConfigurationBase": {
                    return new AppleDeviceFeaturesConfigurationBase();
                }
                case "#microsoft.graph.editionUpgradeConfiguration": {
                    return new EditionUpgradeConfiguration();
                }
                case "#microsoft.graph.iosCertificateProfile": {
                    return new IosCertificateProfile();
                }
                case "#microsoft.graph.iosCustomConfiguration": {
                    return new IosCustomConfiguration();
                }
                case "#microsoft.graph.iosDeviceFeaturesConfiguration": {
                    return new IosDeviceFeaturesConfiguration();
                }
                case "#microsoft.graph.iosGeneralDeviceConfiguration": {
                    return new IosGeneralDeviceConfiguration();
                }
                case "#microsoft.graph.iosUpdateConfiguration": {
                    return new IosUpdateConfiguration();
                }
                case "#microsoft.graph.macOSCustomConfiguration": {
                    return new MacOSCustomConfiguration();
                }
                case "#microsoft.graph.macOSDeviceFeaturesConfiguration": {
                    return new MacOSDeviceFeaturesConfiguration();
                }
                case "#microsoft.graph.macOSGeneralDeviceConfiguration": {
                    return new MacOSGeneralDeviceConfiguration();
                }
                case "#microsoft.graph.sharedPCConfiguration": {
                    return new SharedPCConfiguration();
                }
                case "#microsoft.graph.windows10CustomConfiguration": {
                    return new Windows10CustomConfiguration();
                }
                case "#microsoft.graph.windows10EndpointProtectionConfiguration": {
                    return new Windows10EndpointProtectionConfiguration();
                }
                case "#microsoft.graph.windows10EnterpriseModernAppManagementConfiguration": {
                    return new Windows10EnterpriseModernAppManagementConfiguration();
                }
                case "#microsoft.graph.windows10GeneralConfiguration": {
                    return new Windows10GeneralConfiguration();
                }
                case "#microsoft.graph.windows10SecureAssessmentConfiguration": {
                    return new Windows10SecureAssessmentConfiguration();
                }
                case "#microsoft.graph.windows10TeamGeneralConfiguration": {
                    return new Windows10TeamGeneralConfiguration();
                }
                case "#microsoft.graph.windows81GeneralConfiguration": {
                    return new Windows81GeneralConfiguration();
                }
                case "#microsoft.graph.windowsDefenderAdvancedThreatProtectionConfiguration": {
                    return new WindowsDefenderAdvancedThreatProtectionConfiguration();
                }
                case "#microsoft.graph.windowsPhone81CustomConfiguration": {
                    return new WindowsPhone81CustomConfiguration();
                }
                case "#microsoft.graph.windowsPhone81GeneralConfiguration": {
                    return new WindowsPhone81GeneralConfiguration();
                }
                case "#microsoft.graph.windowsUpdateForBusinessConfiguration": {
                    return new WindowsUpdateForBusinessConfiguration();
                }
            }
        }
        return new DeviceConfiguration();
    }

    @Nullable
    public List<DeviceConfigurationAssignment> getAssignments() {
        return (List)this.backingStore.get("assignments");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public List<SettingStateDeviceSummary> getDeviceSettingStateSummaries() {
        return (List)this.backingStore.get("deviceSettingStateSummaries");
    }

    @Nullable
    public List<DeviceConfigurationDeviceStatus> getDeviceStatuses() {
        return (List)this.backingStore.get("deviceStatuses");
    }

    @Nullable
    public DeviceConfigurationDeviceOverview getDeviceStatusOverview() {
        return (DeviceConfigurationDeviceOverview)this.backingStore.get("deviceStatusOverview");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignments", n -> this.setAssignments(n.getCollectionOfObjectValues(DeviceConfigurationAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("deviceSettingStateSummaries", n -> this.setDeviceSettingStateSummaries(n.getCollectionOfObjectValues(SettingStateDeviceSummary::createFromDiscriminatorValue)));
        deserializerMap.put("deviceStatuses", n -> this.setDeviceStatuses(n.getCollectionOfObjectValues(DeviceConfigurationDeviceStatus::createFromDiscriminatorValue)));
        deserializerMap.put("deviceStatusOverview", n -> this.setDeviceStatusOverview((DeviceConfigurationDeviceOverview)n.getObjectValue(DeviceConfigurationDeviceOverview::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("userStatuses", n -> this.setUserStatuses(n.getCollectionOfObjectValues(DeviceConfigurationUserStatus::createFromDiscriminatorValue)));
        deserializerMap.put("userStatusOverview", n -> this.setUserStatusOverview((DeviceConfigurationUserOverview)n.getObjectValue(DeviceConfigurationUserOverview::createFromDiscriminatorValue)));
        deserializerMap.put("version", n -> this.setVersion(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public List<DeviceConfigurationUserStatus> getUserStatuses() {
        return (List)this.backingStore.get("userStatuses");
    }

    @Nullable
    public DeviceConfigurationUserOverview getUserStatusOverview() {
        return (DeviceConfigurationUserOverview)this.backingStore.get("userStatusOverview");
    }

    @Nullable
    public Integer getVersion() {
        return (Integer)this.backingStore.get("version");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("assignments", this.getAssignments());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeCollectionOfObjectValues("deviceSettingStateSummaries", this.getDeviceSettingStateSummaries());
        writer.writeCollectionOfObjectValues("deviceStatuses", this.getDeviceStatuses());
        writer.writeObjectValue("deviceStatusOverview", (Parsable)this.getDeviceStatusOverview(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeCollectionOfObjectValues("userStatuses", this.getUserStatuses());
        writer.writeObjectValue("userStatusOverview", (Parsable)this.getUserStatusOverview(), new Parsable[0]);
        writer.writeIntegerValue("version", this.getVersion());
    }

    public void setAssignments(@Nullable List<DeviceConfigurationAssignment> value) {
        this.backingStore.set("assignments", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDeviceSettingStateSummaries(@Nullable List<SettingStateDeviceSummary> value) {
        this.backingStore.set("deviceSettingStateSummaries", value);
    }

    public void setDeviceStatuses(@Nullable List<DeviceConfigurationDeviceStatus> value) {
        this.backingStore.set("deviceStatuses", value);
    }

    public void setDeviceStatusOverview(@Nullable DeviceConfigurationDeviceOverview value) {
        this.backingStore.set("deviceStatusOverview", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setUserStatuses(@Nullable List<DeviceConfigurationUserStatus> value) {
        this.backingStore.set("userStatuses", value);
    }

    public void setUserStatusOverview(@Nullable DeviceConfigurationUserOverview value) {
        this.backingStore.set("userStatusOverview", (Object)value);
    }

    public void setVersion(@Nullable Integer value) {
        this.backingStore.set("version", (Object)value);
    }
}

