/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EndUserNotificationPreference;
import com.microsoft.graph.models.EndUserNotificationSettingType;
import com.microsoft.graph.models.NoTrainingNotificationSetting;
import com.microsoft.graph.models.PositiveReinforcementNotification;
import com.microsoft.graph.models.TrainingNotificationSetting;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EndUserNotificationSetting
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public EndUserNotificationSetting() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static EndUserNotificationSetting createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.noTrainingNotificationSetting": {
                    return new NoTrainingNotificationSetting();
                }
                case "#microsoft.graph.trainingNotificationSetting": {
                    return new TrainingNotificationSetting();
                }
            }
        }
        return new EndUserNotificationSetting();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("notificationPreference", n -> this.setNotificationPreference((EndUserNotificationPreference)n.getEnumValue(EndUserNotificationPreference::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("positiveReinforcement", n -> this.setPositiveReinforcement((PositiveReinforcementNotification)n.getObjectValue(PositiveReinforcementNotification::createFromDiscriminatorValue)));
        deserializerMap.put("settingType", n -> this.setSettingType((EndUserNotificationSettingType)n.getEnumValue(EndUserNotificationSettingType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public EndUserNotificationPreference getNotificationPreference() {
        return (EndUserNotificationPreference)((Object)this.backingStore.get("notificationPreference"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public PositiveReinforcementNotification getPositiveReinforcement() {
        return (PositiveReinforcementNotification)this.backingStore.get("positiveReinforcement");
    }

    @Nullable
    public EndUserNotificationSettingType getSettingType() {
        return (EndUserNotificationSettingType)((Object)this.backingStore.get("settingType"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("notificationPreference", (Enum)this.getNotificationPreference());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("positiveReinforcement", (Parsable)this.getPositiveReinforcement(), new Parsable[0]);
        writer.writeEnumValue("settingType", (Enum)this.getSettingType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setNotificationPreference(@Nullable EndUserNotificationPreference value) {
        this.backingStore.set("notificationPreference", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPositiveReinforcement(@Nullable PositiveReinforcementNotification value) {
        this.backingStore.set("positiveReinforcement", (Object)value);
    }

    public void setSettingType(@Nullable EndUserNotificationSettingType value) {
        this.backingStore.set("settingType", (Object)value);
    }
}

