/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.EventMessage;
import com.microsoft.graph.models.Location;
import com.microsoft.graph.models.MeetingRequestType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EventMessageRequest
extends EventMessage
implements Parsable {
    public EventMessageRequest() {
        this.setOdataType("#microsoft.graph.eventMessageRequest");
    }

    @Nonnull
    public static EventMessageRequest createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EventMessageRequest();
    }

    @Nullable
    public Boolean getAllowNewTimeProposals() {
        return (Boolean)this.backingStore.get("allowNewTimeProposals");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowNewTimeProposals", n -> this.setAllowNewTimeProposals(n.getBooleanValue()));
        deserializerMap.put("meetingRequestType", n -> this.setMeetingRequestType((MeetingRequestType)n.getEnumValue(MeetingRequestType::forValue)));
        deserializerMap.put("previousEndDateTime", n -> this.setPreviousEndDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("previousLocation", n -> this.setPreviousLocation((Location)n.getObjectValue(Location::createFromDiscriminatorValue)));
        deserializerMap.put("previousStartDateTime", n -> this.setPreviousStartDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("responseRequested", n -> this.setResponseRequested(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public MeetingRequestType getMeetingRequestType() {
        return (MeetingRequestType)((Object)this.backingStore.get("meetingRequestType"));
    }

    @Nullable
    public DateTimeTimeZone getPreviousEndDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("previousEndDateTime");
    }

    @Nullable
    public Location getPreviousLocation() {
        return (Location)this.backingStore.get("previousLocation");
    }

    @Nullable
    public DateTimeTimeZone getPreviousStartDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("previousStartDateTime");
    }

    @Nullable
    public Boolean getResponseRequested() {
        return (Boolean)this.backingStore.get("responseRequested");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("allowNewTimeProposals", this.getAllowNewTimeProposals());
        writer.writeEnumValue("meetingRequestType", (Enum)this.getMeetingRequestType());
        writer.writeObjectValue("previousEndDateTime", (Parsable)this.getPreviousEndDateTime(), new Parsable[0]);
        writer.writeObjectValue("previousLocation", (Parsable)this.getPreviousLocation(), new Parsable[0]);
        writer.writeObjectValue("previousStartDateTime", (Parsable)this.getPreviousStartDateTime(), new Parsable[0]);
        writer.writeBooleanValue("responseRequested", this.getResponseRequested());
    }

    public void setAllowNewTimeProposals(@Nullable Boolean value) {
        this.backingStore.set("allowNewTimeProposals", (Object)value);
    }

    public void setMeetingRequestType(@Nullable MeetingRequestType value) {
        this.backingStore.set("meetingRequestType", (Object)value);
    }

    public void setPreviousEndDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("previousEndDateTime", (Object)value);
    }

    public void setPreviousLocation(@Nullable Location value) {
        this.backingStore.set("previousLocation", (Object)value);
    }

    public void setPreviousStartDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("previousStartDateTime", (Object)value);
    }

    public void setResponseRequested(@Nullable Boolean value) {
        this.backingStore.set("responseRequested", (Object)value);
    }
}

