/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.LocationConstraintItem;
import com.microsoft.graph.models.LocationType;
import com.microsoft.graph.models.LocationUniqueIdType;
import com.microsoft.graph.models.OutlookGeoCoordinates;
import com.microsoft.graph.models.PhysicalAddress;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Location
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Location() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Location createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.locationConstraintItem": {
                    return new LocationConstraintItem();
                }
            }
        }
        return new Location();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public PhysicalAddress getAddress() {
        return (PhysicalAddress)this.backingStore.get("address");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public OutlookGeoCoordinates getCoordinates() {
        return (OutlookGeoCoordinates)this.backingStore.get("coordinates");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("address", n -> this.setAddress((PhysicalAddress)n.getObjectValue(PhysicalAddress::createFromDiscriminatorValue)));
        deserializerMap.put("coordinates", n -> this.setCoordinates((OutlookGeoCoordinates)n.getObjectValue(OutlookGeoCoordinates::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("locationEmailAddress", n -> this.setLocationEmailAddress(n.getStringValue()));
        deserializerMap.put("locationType", n -> this.setLocationType((LocationType)n.getEnumValue(LocationType::forValue)));
        deserializerMap.put("locationUri", n -> this.setLocationUri(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("uniqueId", n -> this.setUniqueId(n.getStringValue()));
        deserializerMap.put("uniqueIdType", n -> this.setUniqueIdType((LocationUniqueIdType)n.getEnumValue(LocationUniqueIdType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getLocationEmailAddress() {
        return (String)this.backingStore.get("locationEmailAddress");
    }

    @Nullable
    public LocationType getLocationType() {
        return (LocationType)((Object)this.backingStore.get("locationType"));
    }

    @Nullable
    public String getLocationUri() {
        return (String)this.backingStore.get("locationUri");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getUniqueId() {
        return (String)this.backingStore.get("uniqueId");
    }

    @Nullable
    public LocationUniqueIdType getUniqueIdType() {
        return (LocationUniqueIdType)((Object)this.backingStore.get("uniqueIdType"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("address", (Parsable)this.getAddress(), new Parsable[0]);
        writer.writeObjectValue("coordinates", (Parsable)this.getCoordinates(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("locationEmailAddress", this.getLocationEmailAddress());
        writer.writeEnumValue("locationType", (Enum)this.getLocationType());
        writer.writeStringValue("locationUri", this.getLocationUri());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("uniqueId", this.getUniqueId());
        writer.writeEnumValue("uniqueIdType", (Enum)this.getUniqueIdType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAddress(@Nullable PhysicalAddress value) {
        this.backingStore.set("address", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCoordinates(@Nullable OutlookGeoCoordinates value) {
        this.backingStore.set("coordinates", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLocationEmailAddress(@Nullable String value) {
        this.backingStore.set("locationEmailAddress", (Object)value);
    }

    public void setLocationType(@Nullable LocationType value) {
        this.backingStore.set("locationType", (Object)value);
    }

    public void setLocationUri(@Nullable String value) {
        this.backingStore.set("locationUri", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setUniqueId(@Nullable String value) {
        this.backingStore.set("uniqueId", (Object)value);
    }

    public void setUniqueIdType(@Nullable LocationUniqueIdType value) {
        this.backingStore.set("uniqueIdType", (Object)value);
    }
}

