/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.MediaStream;
import com.microsoft.graph.models.OnlineMeetingRestricted;
import com.microsoft.graph.models.ParticipantInfo;
import com.microsoft.graph.models.RecordingInfo;
import com.microsoft.graph.models.RemovedState;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Participant
extends Entity
implements Parsable {
    @Nonnull
    public static Participant createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Participant();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("info", n -> this.setInfo((ParticipantInfo)n.getObjectValue(ParticipantInfo::createFromDiscriminatorValue)));
        deserializerMap.put("isInLobby", n -> this.setIsInLobby(n.getBooleanValue()));
        deserializerMap.put("isMuted", n -> this.setIsMuted(n.getBooleanValue()));
        deserializerMap.put("mediaStreams", n -> this.setMediaStreams(n.getCollectionOfObjectValues(MediaStream::createFromDiscriminatorValue)));
        deserializerMap.put("metadata", n -> this.setMetadata(n.getStringValue()));
        deserializerMap.put("recordingInfo", n -> this.setRecordingInfo((RecordingInfo)n.getObjectValue(RecordingInfo::createFromDiscriminatorValue)));
        deserializerMap.put("removedState", n -> this.setRemovedState((RemovedState)n.getObjectValue(RemovedState::createFromDiscriminatorValue)));
        deserializerMap.put("restrictedExperience", n -> this.setRestrictedExperience((OnlineMeetingRestricted)n.getObjectValue(OnlineMeetingRestricted::createFromDiscriminatorValue)));
        deserializerMap.put("rosterSequenceNumber", n -> this.setRosterSequenceNumber(n.getLongValue()));
        return deserializerMap;
    }

    @Nullable
    public ParticipantInfo getInfo() {
        return (ParticipantInfo)this.backingStore.get("info");
    }

    @Nullable
    public Boolean getIsInLobby() {
        return (Boolean)this.backingStore.get("isInLobby");
    }

    @Nullable
    public Boolean getIsMuted() {
        return (Boolean)this.backingStore.get("isMuted");
    }

    @Nullable
    public List<MediaStream> getMediaStreams() {
        return (List)this.backingStore.get("mediaStreams");
    }

    @Nullable
    public String getMetadata() {
        return (String)this.backingStore.get("metadata");
    }

    @Nullable
    public RecordingInfo getRecordingInfo() {
        return (RecordingInfo)this.backingStore.get("recordingInfo");
    }

    @Nullable
    public RemovedState getRemovedState() {
        return (RemovedState)this.backingStore.get("removedState");
    }

    @Nullable
    public OnlineMeetingRestricted getRestrictedExperience() {
        return (OnlineMeetingRestricted)this.backingStore.get("restrictedExperience");
    }

    @Nullable
    public Long getRosterSequenceNumber() {
        return (Long)this.backingStore.get("rosterSequenceNumber");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("info", (Parsable)this.getInfo(), new Parsable[0]);
        writer.writeBooleanValue("isInLobby", this.getIsInLobby());
        writer.writeBooleanValue("isMuted", this.getIsMuted());
        writer.writeCollectionOfObjectValues("mediaStreams", this.getMediaStreams());
        writer.writeStringValue("metadata", this.getMetadata());
        writer.writeObjectValue("recordingInfo", (Parsable)this.getRecordingInfo(), new Parsable[0]);
        writer.writeObjectValue("removedState", (Parsable)this.getRemovedState(), new Parsable[0]);
        writer.writeObjectValue("restrictedExperience", (Parsable)this.getRestrictedExperience(), new Parsable[0]);
        writer.writeLongValue("rosterSequenceNumber", this.getRosterSequenceNumber());
    }

    public void setInfo(@Nullable ParticipantInfo value) {
        this.backingStore.set("info", (Object)value);
    }

    public void setIsInLobby(@Nullable Boolean value) {
        this.backingStore.set("isInLobby", (Object)value);
    }

    public void setIsMuted(@Nullable Boolean value) {
        this.backingStore.set("isMuted", (Object)value);
    }

    public void setMediaStreams(@Nullable List<MediaStream> value) {
        this.backingStore.set("mediaStreams", value);
    }

    public void setMetadata(@Nullable String value) {
        this.backingStore.set("metadata", (Object)value);
    }

    public void setRecordingInfo(@Nullable RecordingInfo value) {
        this.backingStore.set("recordingInfo", (Object)value);
    }

    public void setRemovedState(@Nullable RemovedState value) {
        this.backingStore.set("removedState", (Object)value);
    }

    public void setRestrictedExperience(@Nullable OnlineMeetingRestricted value) {
        this.backingStore.set("restrictedExperience", (Object)value);
    }

    public void setRosterSequenceNumber(@Nullable Long value) {
        this.backingStore.set("rosterSequenceNumber", (Object)value);
    }
}

