/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ActivityBasedTimeoutPolicy;
import com.microsoft.graph.models.AppManagementPolicy;
import com.microsoft.graph.models.AuthorizationPolicy;
import com.microsoft.graph.models.ClaimsMappingPolicy;
import com.microsoft.graph.models.CrossTenantAccessPolicy;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.HomeRealmDiscoveryPolicy;
import com.microsoft.graph.models.IdentitySecurityDefaultsEnforcementPolicy;
import com.microsoft.graph.models.PermissionGrantPolicy;
import com.microsoft.graph.models.StsPolicy;
import com.microsoft.graph.models.TenantAppManagementPolicy;
import com.microsoft.graph.models.TokenIssuancePolicy;
import com.microsoft.graph.models.TokenLifetimePolicy;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PolicyBase
extends DirectoryObject
implements Parsable {
    public PolicyBase() {
        this.setOdataType("#microsoft.graph.policyBase");
    }

    @Nonnull
    public static PolicyBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.activityBasedTimeoutPolicy": {
                    return new ActivityBasedTimeoutPolicy();
                }
                case "#microsoft.graph.appManagementPolicy": {
                    return new AppManagementPolicy();
                }
                case "#microsoft.graph.authorizationPolicy": {
                    return new AuthorizationPolicy();
                }
                case "#microsoft.graph.claimsMappingPolicy": {
                    return new ClaimsMappingPolicy();
                }
                case "#microsoft.graph.crossTenantAccessPolicy": {
                    return new CrossTenantAccessPolicy();
                }
                case "#microsoft.graph.homeRealmDiscoveryPolicy": {
                    return new HomeRealmDiscoveryPolicy();
                }
                case "#microsoft.graph.identitySecurityDefaultsEnforcementPolicy": {
                    return new IdentitySecurityDefaultsEnforcementPolicy();
                }
                case "#microsoft.graph.permissionGrantPolicy": {
                    return new PermissionGrantPolicy();
                }
                case "#microsoft.graph.stsPolicy": {
                    return new StsPolicy();
                }
                case "#microsoft.graph.tenantAppManagementPolicy": {
                    return new TenantAppManagementPolicy();
                }
                case "#microsoft.graph.tokenIssuancePolicy": {
                    return new TokenIssuancePolicy();
                }
                case "#microsoft.graph.tokenLifetimePolicy": {
                    return new TokenLifetimePolicy();
                }
            }
        }
        return new PolicyBase();
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        return deserializerMap;
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }
}

