/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ContactRelationship;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RelatedContact
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public RelatedContact() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static RelatedContact createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new RelatedContact();
    }

    @Nullable
    public Boolean getAccessConsent() {
        return (Boolean)this.backingStore.get("accessConsent");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public String getEmailAddress() {
        return (String)this.backingStore.get("emailAddress");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("accessConsent", n -> this.setAccessConsent(n.getBooleanValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("emailAddress", n -> this.setEmailAddress(n.getStringValue()));
        deserializerMap.put("mobilePhone", n -> this.setMobilePhone(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("relationship", n -> this.setRelationship((ContactRelationship)n.getEnumValue(ContactRelationship::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getMobilePhone() {
        return (String)this.backingStore.get("mobilePhone");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public ContactRelationship getRelationship() {
        return (ContactRelationship)((Object)this.backingStore.get("relationship"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("accessConsent", this.getAccessConsent());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("emailAddress", this.getEmailAddress());
        writer.writeStringValue("mobilePhone", this.getMobilePhone());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("relationship", (Enum)this.getRelationship());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAccessConsent(@Nullable Boolean value) {
        this.backingStore.set("accessConsent", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEmailAddress(@Nullable String value) {
        this.backingStore.set("emailAddress", (Object)value);
    }

    public void setMobilePhone(@Nullable String value) {
        this.backingStore.set("mobilePhone", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRelationship(@Nullable ContactRelationship value) {
        this.backingStore.set("relationship", (Object)value);
    }
}

