/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SearchHit
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SearchHit() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SearchHit createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SearchHit();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getContentSource() {
        return (String)this.backingStore.get("contentSource");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("contentSource", n -> this.setContentSource(n.getStringValue()));
        deserializerMap.put("hitId", n -> this.setHitId(n.getStringValue()));
        deserializerMap.put("isCollapsed", n -> this.setIsCollapsed(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("rank", n -> this.setRank(n.getIntegerValue()));
        deserializerMap.put("resource", n -> this.setResource((Entity)n.getObjectValue(Entity::createFromDiscriminatorValue)));
        deserializerMap.put("resultTemplateId", n -> this.setResultTemplateId(n.getStringValue()));
        deserializerMap.put("summary", n -> this.setSummary(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getHitId() {
        return (String)this.backingStore.get("hitId");
    }

    @Nullable
    public Boolean getIsCollapsed() {
        return (Boolean)this.backingStore.get("isCollapsed");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getRank() {
        return (Integer)this.backingStore.get("rank");
    }

    @Nullable
    public Entity getResource() {
        return (Entity)this.backingStore.get("resource");
    }

    @Nullable
    public String getResultTemplateId() {
        return (String)this.backingStore.get("resultTemplateId");
    }

    @Nullable
    public String getSummary() {
        return (String)this.backingStore.get("summary");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("contentSource", this.getContentSource());
        writer.writeStringValue("hitId", this.getHitId());
        writer.writeBooleanValue("isCollapsed", this.getIsCollapsed());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("rank", this.getRank());
        writer.writeObjectValue("resource", (Parsable)this.getResource(), new Parsable[0]);
        writer.writeStringValue("resultTemplateId", this.getResultTemplateId());
        writer.writeStringValue("summary", this.getSummary());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setContentSource(@Nullable String value) {
        this.backingStore.set("contentSource", (Object)value);
    }

    public void setHitId(@Nullable String value) {
        this.backingStore.set("hitId", (Object)value);
    }

    public void setIsCollapsed(@Nullable Boolean value) {
        this.backingStore.set("isCollapsed", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRank(@Nullable Integer value) {
        this.backingStore.set("rank", (Object)value);
    }

    public void setResource(@Nullable Entity value) {
        this.backingStore.set("resource", (Object)value);
    }

    public void setResultTemplateId(@Nullable String value) {
        this.backingStore.set("resultTemplateId", (Object)value);
    }

    public void setSummary(@Nullable String value) {
        this.backingStore.set("summary", (Object)value);
    }
}

