/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.ServiceAnnouncementAttachment;
import com.microsoft.graph.models.ServiceAnnouncementBase;
import com.microsoft.graph.models.ServiceUpdateCategory;
import com.microsoft.graph.models.ServiceUpdateMessageViewpoint;
import com.microsoft.graph.models.ServiceUpdateSeverity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ServiceUpdateMessage
extends ServiceAnnouncementBase
implements Parsable {
    public ServiceUpdateMessage() {
        this.setOdataType("#microsoft.graph.serviceUpdateMessage");
    }

    @Nonnull
    public static ServiceUpdateMessage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ServiceUpdateMessage();
    }

    @Nullable
    public OffsetDateTime getActionRequiredByDateTime() {
        return (OffsetDateTime)this.backingStore.get("actionRequiredByDateTime");
    }

    @Nullable
    public List<ServiceAnnouncementAttachment> getAttachments() {
        return (List)this.backingStore.get("attachments");
    }

    @Nullable
    public byte[] getAttachmentsArchive() {
        return (byte[])this.backingStore.get("attachmentsArchive");
    }

    @Nullable
    public ItemBody getBody() {
        return (ItemBody)this.backingStore.get("body");
    }

    @Nullable
    public ServiceUpdateCategory getCategory() {
        return (ServiceUpdateCategory)((Object)this.backingStore.get("category"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("actionRequiredByDateTime", n -> this.setActionRequiredByDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("attachments", n -> this.setAttachments(n.getCollectionOfObjectValues(ServiceAnnouncementAttachment::createFromDiscriminatorValue)));
        deserializerMap.put("attachmentsArchive", n -> this.setAttachmentsArchive(n.getByteArrayValue()));
        deserializerMap.put("body", n -> this.setBody((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("category", n -> this.setCategory((ServiceUpdateCategory)n.getEnumValue(ServiceUpdateCategory::forValue)));
        deserializerMap.put("hasAttachments", n -> this.setHasAttachments(n.getBooleanValue()));
        deserializerMap.put("isMajorChange", n -> this.setIsMajorChange(n.getBooleanValue()));
        deserializerMap.put("services", n -> this.setServices(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("severity", n -> this.setSeverity((ServiceUpdateSeverity)n.getEnumValue(ServiceUpdateSeverity::forValue)));
        deserializerMap.put("tags", n -> this.setTags(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("viewPoint", n -> this.setViewPoint((ServiceUpdateMessageViewpoint)n.getObjectValue(ServiceUpdateMessageViewpoint::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getHasAttachments() {
        return (Boolean)this.backingStore.get("hasAttachments");
    }

    @Nullable
    public Boolean getIsMajorChange() {
        return (Boolean)this.backingStore.get("isMajorChange");
    }

    @Nullable
    public List<String> getServices() {
        return (List)this.backingStore.get("services");
    }

    @Nullable
    public ServiceUpdateSeverity getSeverity() {
        return (ServiceUpdateSeverity)((Object)this.backingStore.get("severity"));
    }

    @Nullable
    public List<String> getTags() {
        return (List)this.backingStore.get("tags");
    }

    @Nullable
    public ServiceUpdateMessageViewpoint getViewPoint() {
        return (ServiceUpdateMessageViewpoint)this.backingStore.get("viewPoint");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("actionRequiredByDateTime", this.getActionRequiredByDateTime());
        writer.writeCollectionOfObjectValues("attachments", this.getAttachments());
        writer.writeByteArrayValue("attachmentsArchive", this.getAttachmentsArchive());
        writer.writeObjectValue("body", (Parsable)this.getBody(), new Parsable[0]);
        writer.writeEnumValue("category", (Enum)this.getCategory());
        writer.writeBooleanValue("hasAttachments", this.getHasAttachments());
        writer.writeBooleanValue("isMajorChange", this.getIsMajorChange());
        writer.writeCollectionOfPrimitiveValues("services", this.getServices());
        writer.writeEnumValue("severity", (Enum)this.getSeverity());
        writer.writeCollectionOfPrimitiveValues("tags", this.getTags());
        writer.writeObjectValue("viewPoint", (Parsable)this.getViewPoint(), new Parsable[0]);
    }

    public void setActionRequiredByDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("actionRequiredByDateTime", (Object)value);
    }

    public void setAttachments(@Nullable List<ServiceAnnouncementAttachment> value) {
        this.backingStore.set("attachments", value);
    }

    public void setAttachmentsArchive(@Nullable byte[] value) {
        this.backingStore.set("attachmentsArchive", (Object)value);
    }

    public void setBody(@Nullable ItemBody value) {
        this.backingStore.set("body", (Object)value);
    }

    public void setCategory(@Nullable ServiceUpdateCategory value) {
        this.backingStore.set("category", (Object)value);
    }

    public void setHasAttachments(@Nullable Boolean value) {
        this.backingStore.set("hasAttachments", (Object)value);
    }

    public void setIsMajorChange(@Nullable Boolean value) {
        this.backingStore.set("isMajorChange", (Object)value);
    }

    public void setServices(@Nullable List<String> value) {
        this.backingStore.set("services", value);
    }

    public void setSeverity(@Nullable ServiceUpdateSeverity value) {
        this.backingStore.set("severity", (Object)value);
    }

    public void setTags(@Nullable List<String> value) {
        this.backingStore.set("tags", value);
    }

    public void setViewPoint(@Nullable ServiceUpdateMessageViewpoint value) {
        this.backingStore.set("viewPoint", (Object)value);
    }
}

