/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ScheduleChangeRequest;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TimeOffRequest
extends ScheduleChangeRequest
implements Parsable {
    public TimeOffRequest() {
        this.setOdataType("#microsoft.graph.timeOffRequest");
    }

    @Nonnull
    public static TimeOffRequest createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TimeOffRequest();
    }

    @Nullable
    public OffsetDateTime getEndDateTime() {
        return (OffsetDateTime)this.backingStore.get("endDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("endDateTime", n -> this.setEndDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("timeOffReasonId", n -> this.setTimeOffReasonId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getStartDateTime() {
        return (OffsetDateTime)this.backingStore.get("startDateTime");
    }

    @Nullable
    public String getTimeOffReasonId() {
        return (String)this.backingStore.get("timeOffReasonId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("endDateTime", this.getEndDateTime());
        writer.writeOffsetDateTimeValue("startDateTime", this.getStartDateTime());
        writer.writeStringValue("timeOffReasonId", this.getTimeOffReasonId());
    }

    public void setEndDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setStartDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setTimeOffReasonId(@Nullable String value) {
        this.backingStore.set("timeOffReasonId", (Object)value);
    }
}

