/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.UserExperienceAnalyticsHealthState;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserExperienceAnalyticsDeviceScores
extends Entity
implements Parsable {
    @Nonnull
    public static UserExperienceAnalyticsDeviceScores createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserExperienceAnalyticsDeviceScores();
    }

    @Nullable
    public Double getAppReliabilityScore() {
        return (Double)this.backingStore.get("appReliabilityScore");
    }

    @Nullable
    public Double getBatteryHealthScore() {
        return (Double)this.backingStore.get("batteryHealthScore");
    }

    @Nullable
    public String getDeviceName() {
        return (String)this.backingStore.get("deviceName");
    }

    @Nullable
    public Double getEndpointAnalyticsScore() {
        return (Double)this.backingStore.get("endpointAnalyticsScore");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appReliabilityScore", n -> this.setAppReliabilityScore(n.getDoubleValue()));
        deserializerMap.put("batteryHealthScore", n -> this.setBatteryHealthScore(n.getDoubleValue()));
        deserializerMap.put("deviceName", n -> this.setDeviceName(n.getStringValue()));
        deserializerMap.put("endpointAnalyticsScore", n -> this.setEndpointAnalyticsScore(n.getDoubleValue()));
        deserializerMap.put("healthStatus", n -> this.setHealthStatus((UserExperienceAnalyticsHealthState)n.getEnumValue(UserExperienceAnalyticsHealthState::forValue)));
        deserializerMap.put("manufacturer", n -> this.setManufacturer(n.getStringValue()));
        deserializerMap.put("model", n -> this.setModel(n.getStringValue()));
        deserializerMap.put("startupPerformanceScore", n -> this.setStartupPerformanceScore(n.getDoubleValue()));
        deserializerMap.put("workFromAnywhereScore", n -> this.setWorkFromAnywhereScore(n.getDoubleValue()));
        return deserializerMap;
    }

    @Nullable
    public UserExperienceAnalyticsHealthState getHealthStatus() {
        return (UserExperienceAnalyticsHealthState)((Object)this.backingStore.get("healthStatus"));
    }

    @Nullable
    public String getManufacturer() {
        return (String)this.backingStore.get("manufacturer");
    }

    @Nullable
    public String getModel() {
        return (String)this.backingStore.get("model");
    }

    @Nullable
    public Double getStartupPerformanceScore() {
        return (Double)this.backingStore.get("startupPerformanceScore");
    }

    @Nullable
    public Double getWorkFromAnywhereScore() {
        return (Double)this.backingStore.get("workFromAnywhereScore");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeDoubleValue("appReliabilityScore", this.getAppReliabilityScore());
        writer.writeDoubleValue("batteryHealthScore", this.getBatteryHealthScore());
        writer.writeStringValue("deviceName", this.getDeviceName());
        writer.writeDoubleValue("endpointAnalyticsScore", this.getEndpointAnalyticsScore());
        writer.writeEnumValue("healthStatus", (Enum)this.getHealthStatus());
        writer.writeStringValue("manufacturer", this.getManufacturer());
        writer.writeStringValue("model", this.getModel());
        writer.writeDoubleValue("startupPerformanceScore", this.getStartupPerformanceScore());
        writer.writeDoubleValue("workFromAnywhereScore", this.getWorkFromAnywhereScore());
    }

    public void setAppReliabilityScore(@Nullable Double value) {
        this.backingStore.set("appReliabilityScore", (Object)value);
    }

    public void setBatteryHealthScore(@Nullable Double value) {
        this.backingStore.set("batteryHealthScore", (Object)value);
    }

    public void setDeviceName(@Nullable String value) {
        this.backingStore.set("deviceName", (Object)value);
    }

    public void setEndpointAnalyticsScore(@Nullable Double value) {
        this.backingStore.set("endpointAnalyticsScore", (Object)value);
    }

    public void setHealthStatus(@Nullable UserExperienceAnalyticsHealthState value) {
        this.backingStore.set("healthStatus", (Object)value);
    }

    public void setManufacturer(@Nullable String value) {
        this.backingStore.set("manufacturer", (Object)value);
    }

    public void setModel(@Nullable String value) {
        this.backingStore.set("model", (Object)value);
    }

    public void setStartupPerformanceScore(@Nullable Double value) {
        this.backingStore.set("startupPerformanceScore", (Object)value);
    }

    public void setWorkFromAnywhereScore(@Nullable Double value) {
        this.backingStore.set("workFromAnywhereScore", (Object)value);
    }
}

