/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.StateManagementSetting;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WindowsFirewallNetworkProfile
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WindowsFirewallNetworkProfile() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WindowsFirewallNetworkProfile createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsFirewallNetworkProfile();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Boolean getAuthorizedApplicationRulesFromGroupPolicyMerged() {
        return (Boolean)this.backingStore.get("authorizedApplicationRulesFromGroupPolicyMerged");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Boolean getConnectionSecurityRulesFromGroupPolicyMerged() {
        return (Boolean)this.backingStore.get("connectionSecurityRulesFromGroupPolicyMerged");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(13);
        deserializerMap.put("authorizedApplicationRulesFromGroupPolicyMerged", n -> this.setAuthorizedApplicationRulesFromGroupPolicyMerged(n.getBooleanValue()));
        deserializerMap.put("connectionSecurityRulesFromGroupPolicyMerged", n -> this.setConnectionSecurityRulesFromGroupPolicyMerged(n.getBooleanValue()));
        deserializerMap.put("firewallEnabled", n -> this.setFirewallEnabled((StateManagementSetting)n.getEnumValue(StateManagementSetting::forValue)));
        deserializerMap.put("globalPortRulesFromGroupPolicyMerged", n -> this.setGlobalPortRulesFromGroupPolicyMerged(n.getBooleanValue()));
        deserializerMap.put("inboundConnectionsBlocked", n -> this.setInboundConnectionsBlocked(n.getBooleanValue()));
        deserializerMap.put("inboundNotificationsBlocked", n -> this.setInboundNotificationsBlocked(n.getBooleanValue()));
        deserializerMap.put("incomingTrafficBlocked", n -> this.setIncomingTrafficBlocked(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("outboundConnectionsBlocked", n -> this.setOutboundConnectionsBlocked(n.getBooleanValue()));
        deserializerMap.put("policyRulesFromGroupPolicyMerged", n -> this.setPolicyRulesFromGroupPolicyMerged(n.getBooleanValue()));
        deserializerMap.put("securedPacketExemptionAllowed", n -> this.setSecuredPacketExemptionAllowed(n.getBooleanValue()));
        deserializerMap.put("stealthModeBlocked", n -> this.setStealthModeBlocked(n.getBooleanValue()));
        deserializerMap.put("unicastResponsesToMulticastBroadcastsBlocked", n -> this.setUnicastResponsesToMulticastBroadcastsBlocked(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public StateManagementSetting getFirewallEnabled() {
        return (StateManagementSetting)((Object)this.backingStore.get("firewallEnabled"));
    }

    @Nullable
    public Boolean getGlobalPortRulesFromGroupPolicyMerged() {
        return (Boolean)this.backingStore.get("globalPortRulesFromGroupPolicyMerged");
    }

    @Nullable
    public Boolean getInboundConnectionsBlocked() {
        return (Boolean)this.backingStore.get("inboundConnectionsBlocked");
    }

    @Nullable
    public Boolean getInboundNotificationsBlocked() {
        return (Boolean)this.backingStore.get("inboundNotificationsBlocked");
    }

    @Nullable
    public Boolean getIncomingTrafficBlocked() {
        return (Boolean)this.backingStore.get("incomingTrafficBlocked");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getOutboundConnectionsBlocked() {
        return (Boolean)this.backingStore.get("outboundConnectionsBlocked");
    }

    @Nullable
    public Boolean getPolicyRulesFromGroupPolicyMerged() {
        return (Boolean)this.backingStore.get("policyRulesFromGroupPolicyMerged");
    }

    @Nullable
    public Boolean getSecuredPacketExemptionAllowed() {
        return (Boolean)this.backingStore.get("securedPacketExemptionAllowed");
    }

    @Nullable
    public Boolean getStealthModeBlocked() {
        return (Boolean)this.backingStore.get("stealthModeBlocked");
    }

    @Nullable
    public Boolean getUnicastResponsesToMulticastBroadcastsBlocked() {
        return (Boolean)this.backingStore.get("unicastResponsesToMulticastBroadcastsBlocked");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("authorizedApplicationRulesFromGroupPolicyMerged", this.getAuthorizedApplicationRulesFromGroupPolicyMerged());
        writer.writeBooleanValue("connectionSecurityRulesFromGroupPolicyMerged", this.getConnectionSecurityRulesFromGroupPolicyMerged());
        writer.writeEnumValue("firewallEnabled", (Enum)this.getFirewallEnabled());
        writer.writeBooleanValue("globalPortRulesFromGroupPolicyMerged", this.getGlobalPortRulesFromGroupPolicyMerged());
        writer.writeBooleanValue("inboundConnectionsBlocked", this.getInboundConnectionsBlocked());
        writer.writeBooleanValue("inboundNotificationsBlocked", this.getInboundNotificationsBlocked());
        writer.writeBooleanValue("incomingTrafficBlocked", this.getIncomingTrafficBlocked());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("outboundConnectionsBlocked", this.getOutboundConnectionsBlocked());
        writer.writeBooleanValue("policyRulesFromGroupPolicyMerged", this.getPolicyRulesFromGroupPolicyMerged());
        writer.writeBooleanValue("securedPacketExemptionAllowed", this.getSecuredPacketExemptionAllowed());
        writer.writeBooleanValue("stealthModeBlocked", this.getStealthModeBlocked());
        writer.writeBooleanValue("unicastResponsesToMulticastBroadcastsBlocked", this.getUnicastResponsesToMulticastBroadcastsBlocked());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAuthorizedApplicationRulesFromGroupPolicyMerged(@Nullable Boolean value) {
        this.backingStore.set("authorizedApplicationRulesFromGroupPolicyMerged", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setConnectionSecurityRulesFromGroupPolicyMerged(@Nullable Boolean value) {
        this.backingStore.set("connectionSecurityRulesFromGroupPolicyMerged", (Object)value);
    }

    public void setFirewallEnabled(@Nullable StateManagementSetting value) {
        this.backingStore.set("firewallEnabled", (Object)value);
    }

    public void setGlobalPortRulesFromGroupPolicyMerged(@Nullable Boolean value) {
        this.backingStore.set("globalPortRulesFromGroupPolicyMerged", (Object)value);
    }

    public void setInboundConnectionsBlocked(@Nullable Boolean value) {
        this.backingStore.set("inboundConnectionsBlocked", (Object)value);
    }

    public void setInboundNotificationsBlocked(@Nullable Boolean value) {
        this.backingStore.set("inboundNotificationsBlocked", (Object)value);
    }

    public void setIncomingTrafficBlocked(@Nullable Boolean value) {
        this.backingStore.set("incomingTrafficBlocked", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOutboundConnectionsBlocked(@Nullable Boolean value) {
        this.backingStore.set("outboundConnectionsBlocked", (Object)value);
    }

    public void setPolicyRulesFromGroupPolicyMerged(@Nullable Boolean value) {
        this.backingStore.set("policyRulesFromGroupPolicyMerged", (Object)value);
    }

    public void setSecuredPacketExemptionAllowed(@Nullable Boolean value) {
        this.backingStore.set("securedPacketExemptionAllowed", (Object)value);
    }

    public void setStealthModeBlocked(@Nullable Boolean value) {
        this.backingStore.set("stealthModeBlocked", (Object)value);
    }

    public void setUnicastResponsesToMulticastBroadcastsBlocked(@Nullable Boolean value) {
        this.backingStore.set("unicastResponsesToMulticastBroadcastsBlocked", (Object)value);
    }
}

