/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ManagedAppPolicy;
import com.microsoft.graph.models.MdmWindowsInformationProtectionPolicy;
import com.microsoft.graph.models.TargetedManagedAppPolicyAssignment;
import com.microsoft.graph.models.WindowsInformationProtectionApp;
import com.microsoft.graph.models.WindowsInformationProtectionAppLockerFile;
import com.microsoft.graph.models.WindowsInformationProtectionDataRecoveryCertificate;
import com.microsoft.graph.models.WindowsInformationProtectionEnforcementLevel;
import com.microsoft.graph.models.WindowsInformationProtectionIPRangeCollection;
import com.microsoft.graph.models.WindowsInformationProtectionPolicy;
import com.microsoft.graph.models.WindowsInformationProtectionProxiedDomainCollection;
import com.microsoft.graph.models.WindowsInformationProtectionResourceCollection;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class WindowsInformationProtection
extends ManagedAppPolicy
implements Parsable {
    public WindowsInformationProtection() {
        this.setOdataType("#microsoft.graph.windowsInformationProtection");
    }

    @Nonnull
    public static WindowsInformationProtection createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.mdmWindowsInformationProtectionPolicy": {
                    return new MdmWindowsInformationProtectionPolicy();
                }
                case "#microsoft.graph.windowsInformationProtectionPolicy": {
                    return new WindowsInformationProtectionPolicy();
                }
            }
        }
        return new WindowsInformationProtection();
    }

    @Nullable
    public List<TargetedManagedAppPolicyAssignment> getAssignments() {
        return (List)this.backingStore.get("assignments");
    }

    @Nullable
    public Boolean getAzureRightsManagementServicesAllowed() {
        return (Boolean)this.backingStore.get("azureRightsManagementServicesAllowed");
    }

    @Nullable
    public WindowsInformationProtectionDataRecoveryCertificate getDataRecoveryCertificate() {
        return (WindowsInformationProtectionDataRecoveryCertificate)this.backingStore.get("dataRecoveryCertificate");
    }

    @Nullable
    public WindowsInformationProtectionEnforcementLevel getEnforcementLevel() {
        return (WindowsInformationProtectionEnforcementLevel)((Object)this.backingStore.get("enforcementLevel"));
    }

    @Nullable
    public String getEnterpriseDomain() {
        return (String)this.backingStore.get("enterpriseDomain");
    }

    @Nullable
    public List<WindowsInformationProtectionResourceCollection> getEnterpriseInternalProxyServers() {
        return (List)this.backingStore.get("enterpriseInternalProxyServers");
    }

    @Nullable
    public List<WindowsInformationProtectionIPRangeCollection> getEnterpriseIPRanges() {
        return (List)this.backingStore.get("enterpriseIPRanges");
    }

    @Nullable
    public Boolean getEnterpriseIPRangesAreAuthoritative() {
        return (Boolean)this.backingStore.get("enterpriseIPRangesAreAuthoritative");
    }

    @Nullable
    public List<WindowsInformationProtectionResourceCollection> getEnterpriseNetworkDomainNames() {
        return (List)this.backingStore.get("enterpriseNetworkDomainNames");
    }

    @Nullable
    public List<WindowsInformationProtectionResourceCollection> getEnterpriseProtectedDomainNames() {
        return (List)this.backingStore.get("enterpriseProtectedDomainNames");
    }

    @Nullable
    public List<WindowsInformationProtectionProxiedDomainCollection> getEnterpriseProxiedDomains() {
        return (List)this.backingStore.get("enterpriseProxiedDomains");
    }

    @Nullable
    public List<WindowsInformationProtectionResourceCollection> getEnterpriseProxyServers() {
        return (List)this.backingStore.get("enterpriseProxyServers");
    }

    @Nullable
    public Boolean getEnterpriseProxyServersAreAuthoritative() {
        return (Boolean)this.backingStore.get("enterpriseProxyServersAreAuthoritative");
    }

    @Nullable
    public List<WindowsInformationProtectionAppLockerFile> getExemptAppLockerFiles() {
        return (List)this.backingStore.get("exemptAppLockerFiles");
    }

    @Nullable
    public List<WindowsInformationProtectionApp> getExemptApps() {
        return (List)this.backingStore.get("exemptApps");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignments", n -> this.setAssignments(n.getCollectionOfObjectValues(TargetedManagedAppPolicyAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("azureRightsManagementServicesAllowed", n -> this.setAzureRightsManagementServicesAllowed(n.getBooleanValue()));
        deserializerMap.put("dataRecoveryCertificate", n -> this.setDataRecoveryCertificate((WindowsInformationProtectionDataRecoveryCertificate)n.getObjectValue(WindowsInformationProtectionDataRecoveryCertificate::createFromDiscriminatorValue)));
        deserializerMap.put("enforcementLevel", n -> this.setEnforcementLevel((WindowsInformationProtectionEnforcementLevel)n.getEnumValue(WindowsInformationProtectionEnforcementLevel::forValue)));
        deserializerMap.put("enterpriseDomain", n -> this.setEnterpriseDomain(n.getStringValue()));
        deserializerMap.put("enterpriseInternalProxyServers", n -> this.setEnterpriseInternalProxyServers(n.getCollectionOfObjectValues(WindowsInformationProtectionResourceCollection::createFromDiscriminatorValue)));
        deserializerMap.put("enterpriseIPRanges", n -> this.setEnterpriseIPRanges(n.getCollectionOfObjectValues(WindowsInformationProtectionIPRangeCollection::createFromDiscriminatorValue)));
        deserializerMap.put("enterpriseIPRangesAreAuthoritative", n -> this.setEnterpriseIPRangesAreAuthoritative(n.getBooleanValue()));
        deserializerMap.put("enterpriseNetworkDomainNames", n -> this.setEnterpriseNetworkDomainNames(n.getCollectionOfObjectValues(WindowsInformationProtectionResourceCollection::createFromDiscriminatorValue)));
        deserializerMap.put("enterpriseProtectedDomainNames", n -> this.setEnterpriseProtectedDomainNames(n.getCollectionOfObjectValues(WindowsInformationProtectionResourceCollection::createFromDiscriminatorValue)));
        deserializerMap.put("enterpriseProxiedDomains", n -> this.setEnterpriseProxiedDomains(n.getCollectionOfObjectValues(WindowsInformationProtectionProxiedDomainCollection::createFromDiscriminatorValue)));
        deserializerMap.put("enterpriseProxyServers", n -> this.setEnterpriseProxyServers(n.getCollectionOfObjectValues(WindowsInformationProtectionResourceCollection::createFromDiscriminatorValue)));
        deserializerMap.put("enterpriseProxyServersAreAuthoritative", n -> this.setEnterpriseProxyServersAreAuthoritative(n.getBooleanValue()));
        deserializerMap.put("exemptAppLockerFiles", n -> this.setExemptAppLockerFiles(n.getCollectionOfObjectValues(WindowsInformationProtectionAppLockerFile::createFromDiscriminatorValue)));
        deserializerMap.put("exemptApps", n -> this.setExemptApps(n.getCollectionOfObjectValues(WindowsInformationProtectionApp::createFromDiscriminatorValue)));
        deserializerMap.put("iconsVisible", n -> this.setIconsVisible(n.getBooleanValue()));
        deserializerMap.put("indexingEncryptedStoresOrItemsBlocked", n -> this.setIndexingEncryptedStoresOrItemsBlocked(n.getBooleanValue()));
        deserializerMap.put("isAssigned", n -> this.setIsAssigned(n.getBooleanValue()));
        deserializerMap.put("neutralDomainResources", n -> this.setNeutralDomainResources(n.getCollectionOfObjectValues(WindowsInformationProtectionResourceCollection::createFromDiscriminatorValue)));
        deserializerMap.put("protectedAppLockerFiles", n -> this.setProtectedAppLockerFiles(n.getCollectionOfObjectValues(WindowsInformationProtectionAppLockerFile::createFromDiscriminatorValue)));
        deserializerMap.put("protectedApps", n -> this.setProtectedApps(n.getCollectionOfObjectValues(WindowsInformationProtectionApp::createFromDiscriminatorValue)));
        deserializerMap.put("protectionUnderLockConfigRequired", n -> this.setProtectionUnderLockConfigRequired(n.getBooleanValue()));
        deserializerMap.put("revokeOnUnenrollDisabled", n -> this.setRevokeOnUnenrollDisabled(n.getBooleanValue()));
        deserializerMap.put("rightsManagementServicesTemplateId", n -> this.setRightsManagementServicesTemplateId(n.getUUIDValue()));
        deserializerMap.put("smbAutoEncryptedFileExtensions", n -> this.setSmbAutoEncryptedFileExtensions(n.getCollectionOfObjectValues(WindowsInformationProtectionResourceCollection::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIconsVisible() {
        return (Boolean)this.backingStore.get("iconsVisible");
    }

    @Nullable
    public Boolean getIndexingEncryptedStoresOrItemsBlocked() {
        return (Boolean)this.backingStore.get("indexingEncryptedStoresOrItemsBlocked");
    }

    @Nullable
    public Boolean getIsAssigned() {
        return (Boolean)this.backingStore.get("isAssigned");
    }

    @Nullable
    public List<WindowsInformationProtectionResourceCollection> getNeutralDomainResources() {
        return (List)this.backingStore.get("neutralDomainResources");
    }

    @Nullable
    public List<WindowsInformationProtectionAppLockerFile> getProtectedAppLockerFiles() {
        return (List)this.backingStore.get("protectedAppLockerFiles");
    }

    @Nullable
    public List<WindowsInformationProtectionApp> getProtectedApps() {
        return (List)this.backingStore.get("protectedApps");
    }

    @Nullable
    public Boolean getProtectionUnderLockConfigRequired() {
        return (Boolean)this.backingStore.get("protectionUnderLockConfigRequired");
    }

    @Nullable
    public Boolean getRevokeOnUnenrollDisabled() {
        return (Boolean)this.backingStore.get("revokeOnUnenrollDisabled");
    }

    @Nullable
    public UUID getRightsManagementServicesTemplateId() {
        return (UUID)this.backingStore.get("rightsManagementServicesTemplateId");
    }

    @Nullable
    public List<WindowsInformationProtectionResourceCollection> getSmbAutoEncryptedFileExtensions() {
        return (List)this.backingStore.get("smbAutoEncryptedFileExtensions");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("assignments", this.getAssignments());
        writer.writeBooleanValue("azureRightsManagementServicesAllowed", this.getAzureRightsManagementServicesAllowed());
        writer.writeObjectValue("dataRecoveryCertificate", (Parsable)this.getDataRecoveryCertificate(), new Parsable[0]);
        writer.writeEnumValue("enforcementLevel", (Enum)this.getEnforcementLevel());
        writer.writeStringValue("enterpriseDomain", this.getEnterpriseDomain());
        writer.writeCollectionOfObjectValues("enterpriseInternalProxyServers", this.getEnterpriseInternalProxyServers());
        writer.writeCollectionOfObjectValues("enterpriseIPRanges", this.getEnterpriseIPRanges());
        writer.writeBooleanValue("enterpriseIPRangesAreAuthoritative", this.getEnterpriseIPRangesAreAuthoritative());
        writer.writeCollectionOfObjectValues("enterpriseNetworkDomainNames", this.getEnterpriseNetworkDomainNames());
        writer.writeCollectionOfObjectValues("enterpriseProtectedDomainNames", this.getEnterpriseProtectedDomainNames());
        writer.writeCollectionOfObjectValues("enterpriseProxiedDomains", this.getEnterpriseProxiedDomains());
        writer.writeCollectionOfObjectValues("enterpriseProxyServers", this.getEnterpriseProxyServers());
        writer.writeBooleanValue("enterpriseProxyServersAreAuthoritative", this.getEnterpriseProxyServersAreAuthoritative());
        writer.writeCollectionOfObjectValues("exemptAppLockerFiles", this.getExemptAppLockerFiles());
        writer.writeCollectionOfObjectValues("exemptApps", this.getExemptApps());
        writer.writeBooleanValue("iconsVisible", this.getIconsVisible());
        writer.writeBooleanValue("indexingEncryptedStoresOrItemsBlocked", this.getIndexingEncryptedStoresOrItemsBlocked());
        writer.writeBooleanValue("isAssigned", this.getIsAssigned());
        writer.writeCollectionOfObjectValues("neutralDomainResources", this.getNeutralDomainResources());
        writer.writeCollectionOfObjectValues("protectedAppLockerFiles", this.getProtectedAppLockerFiles());
        writer.writeCollectionOfObjectValues("protectedApps", this.getProtectedApps());
        writer.writeBooleanValue("protectionUnderLockConfigRequired", this.getProtectionUnderLockConfigRequired());
        writer.writeBooleanValue("revokeOnUnenrollDisabled", this.getRevokeOnUnenrollDisabled());
        writer.writeUUIDValue("rightsManagementServicesTemplateId", this.getRightsManagementServicesTemplateId());
        writer.writeCollectionOfObjectValues("smbAutoEncryptedFileExtensions", this.getSmbAutoEncryptedFileExtensions());
    }

    public void setAssignments(@Nullable List<TargetedManagedAppPolicyAssignment> value) {
        this.backingStore.set("assignments", value);
    }

    public void setAzureRightsManagementServicesAllowed(@Nullable Boolean value) {
        this.backingStore.set("azureRightsManagementServicesAllowed", (Object)value);
    }

    public void setDataRecoveryCertificate(@Nullable WindowsInformationProtectionDataRecoveryCertificate value) {
        this.backingStore.set("dataRecoveryCertificate", (Object)value);
    }

    public void setEnforcementLevel(@Nullable WindowsInformationProtectionEnforcementLevel value) {
        this.backingStore.set("enforcementLevel", (Object)value);
    }

    public void setEnterpriseDomain(@Nullable String value) {
        this.backingStore.set("enterpriseDomain", (Object)value);
    }

    public void setEnterpriseInternalProxyServers(@Nullable List<WindowsInformationProtectionResourceCollection> value) {
        this.backingStore.set("enterpriseInternalProxyServers", value);
    }

    public void setEnterpriseIPRanges(@Nullable List<WindowsInformationProtectionIPRangeCollection> value) {
        this.backingStore.set("enterpriseIPRanges", value);
    }

    public void setEnterpriseIPRangesAreAuthoritative(@Nullable Boolean value) {
        this.backingStore.set("enterpriseIPRangesAreAuthoritative", (Object)value);
    }

    public void setEnterpriseNetworkDomainNames(@Nullable List<WindowsInformationProtectionResourceCollection> value) {
        this.backingStore.set("enterpriseNetworkDomainNames", value);
    }

    public void setEnterpriseProtectedDomainNames(@Nullable List<WindowsInformationProtectionResourceCollection> value) {
        this.backingStore.set("enterpriseProtectedDomainNames", value);
    }

    public void setEnterpriseProxiedDomains(@Nullable List<WindowsInformationProtectionProxiedDomainCollection> value) {
        this.backingStore.set("enterpriseProxiedDomains", value);
    }

    public void setEnterpriseProxyServers(@Nullable List<WindowsInformationProtectionResourceCollection> value) {
        this.backingStore.set("enterpriseProxyServers", value);
    }

    public void setEnterpriseProxyServersAreAuthoritative(@Nullable Boolean value) {
        this.backingStore.set("enterpriseProxyServersAreAuthoritative", (Object)value);
    }

    public void setExemptAppLockerFiles(@Nullable List<WindowsInformationProtectionAppLockerFile> value) {
        this.backingStore.set("exemptAppLockerFiles", value);
    }

    public void setExemptApps(@Nullable List<WindowsInformationProtectionApp> value) {
        this.backingStore.set("exemptApps", value);
    }

    public void setIconsVisible(@Nullable Boolean value) {
        this.backingStore.set("iconsVisible", (Object)value);
    }

    public void setIndexingEncryptedStoresOrItemsBlocked(@Nullable Boolean value) {
        this.backingStore.set("indexingEncryptedStoresOrItemsBlocked", (Object)value);
    }

    public void setIsAssigned(@Nullable Boolean value) {
        this.backingStore.set("isAssigned", (Object)value);
    }

    public void setNeutralDomainResources(@Nullable List<WindowsInformationProtectionResourceCollection> value) {
        this.backingStore.set("neutralDomainResources", value);
    }

    public void setProtectedAppLockerFiles(@Nullable List<WindowsInformationProtectionAppLockerFile> value) {
        this.backingStore.set("protectedAppLockerFiles", value);
    }

    public void setProtectedApps(@Nullable List<WindowsInformationProtectionApp> value) {
        this.backingStore.set("protectedApps", value);
    }

    public void setProtectionUnderLockConfigRequired(@Nullable Boolean value) {
        this.backingStore.set("protectionUnderLockConfigRequired", (Object)value);
    }

    public void setRevokeOnUnenrollDisabled(@Nullable Boolean value) {
        this.backingStore.set("revokeOnUnenrollDisabled", (Object)value);
    }

    public void setRightsManagementServicesTemplateId(@Nullable UUID value) {
        this.backingStore.set("rightsManagementServicesTemplateId", (Object)value);
    }

    public void setSmbAutoEncryptedFileExtensions(@Nullable List<WindowsInformationProtectionResourceCollection> value) {
        this.backingStore.set("smbAutoEncryptedFileExtensions", value);
    }
}

