/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.WindowsInformationProtection;
import com.microsoft.graph.models.WindowsInformationProtectionPinCharacterRequirements;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WindowsInformationProtectionPolicy
extends WindowsInformationProtection
implements Parsable {
    public WindowsInformationProtectionPolicy() {
        this.setOdataType("#microsoft.graph.windowsInformationProtectionPolicy");
    }

    @Nonnull
    public static WindowsInformationProtectionPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsInformationProtectionPolicy();
    }

    @Nullable
    public Integer getDaysWithoutContactBeforeUnenroll() {
        return (Integer)this.backingStore.get("daysWithoutContactBeforeUnenroll");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("daysWithoutContactBeforeUnenroll", n -> this.setDaysWithoutContactBeforeUnenroll(n.getIntegerValue()));
        deserializerMap.put("mdmEnrollmentUrl", n -> this.setMdmEnrollmentUrl(n.getStringValue()));
        deserializerMap.put("minutesOfInactivityBeforeDeviceLock", n -> this.setMinutesOfInactivityBeforeDeviceLock(n.getIntegerValue()));
        deserializerMap.put("numberOfPastPinsRemembered", n -> this.setNumberOfPastPinsRemembered(n.getIntegerValue()));
        deserializerMap.put("passwordMaximumAttemptCount", n -> this.setPasswordMaximumAttemptCount(n.getIntegerValue()));
        deserializerMap.put("pinExpirationDays", n -> this.setPinExpirationDays(n.getIntegerValue()));
        deserializerMap.put("pinLowercaseLetters", n -> this.setPinLowercaseLetters((WindowsInformationProtectionPinCharacterRequirements)n.getEnumValue(WindowsInformationProtectionPinCharacterRequirements::forValue)));
        deserializerMap.put("pinMinimumLength", n -> this.setPinMinimumLength(n.getIntegerValue()));
        deserializerMap.put("pinSpecialCharacters", n -> this.setPinSpecialCharacters((WindowsInformationProtectionPinCharacterRequirements)n.getEnumValue(WindowsInformationProtectionPinCharacterRequirements::forValue)));
        deserializerMap.put("pinUppercaseLetters", n -> this.setPinUppercaseLetters((WindowsInformationProtectionPinCharacterRequirements)n.getEnumValue(WindowsInformationProtectionPinCharacterRequirements::forValue)));
        deserializerMap.put("revokeOnMdmHandoffDisabled", n -> this.setRevokeOnMdmHandoffDisabled(n.getBooleanValue()));
        deserializerMap.put("windowsHelloForBusinessBlocked", n -> this.setWindowsHelloForBusinessBlocked(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public String getMdmEnrollmentUrl() {
        return (String)this.backingStore.get("mdmEnrollmentUrl");
    }

    @Nullable
    public Integer getMinutesOfInactivityBeforeDeviceLock() {
        return (Integer)this.backingStore.get("minutesOfInactivityBeforeDeviceLock");
    }

    @Nullable
    public Integer getNumberOfPastPinsRemembered() {
        return (Integer)this.backingStore.get("numberOfPastPinsRemembered");
    }

    @Nullable
    public Integer getPasswordMaximumAttemptCount() {
        return (Integer)this.backingStore.get("passwordMaximumAttemptCount");
    }

    @Nullable
    public Integer getPinExpirationDays() {
        return (Integer)this.backingStore.get("pinExpirationDays");
    }

    @Nullable
    public WindowsInformationProtectionPinCharacterRequirements getPinLowercaseLetters() {
        return (WindowsInformationProtectionPinCharacterRequirements)((Object)this.backingStore.get("pinLowercaseLetters"));
    }

    @Nullable
    public Integer getPinMinimumLength() {
        return (Integer)this.backingStore.get("pinMinimumLength");
    }

    @Nullable
    public WindowsInformationProtectionPinCharacterRequirements getPinSpecialCharacters() {
        return (WindowsInformationProtectionPinCharacterRequirements)((Object)this.backingStore.get("pinSpecialCharacters"));
    }

    @Nullable
    public WindowsInformationProtectionPinCharacterRequirements getPinUppercaseLetters() {
        return (WindowsInformationProtectionPinCharacterRequirements)((Object)this.backingStore.get("pinUppercaseLetters"));
    }

    @Nullable
    public Boolean getRevokeOnMdmHandoffDisabled() {
        return (Boolean)this.backingStore.get("revokeOnMdmHandoffDisabled");
    }

    @Nullable
    public Boolean getWindowsHelloForBusinessBlocked() {
        return (Boolean)this.backingStore.get("windowsHelloForBusinessBlocked");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("daysWithoutContactBeforeUnenroll", this.getDaysWithoutContactBeforeUnenroll());
        writer.writeStringValue("mdmEnrollmentUrl", this.getMdmEnrollmentUrl());
        writer.writeIntegerValue("minutesOfInactivityBeforeDeviceLock", this.getMinutesOfInactivityBeforeDeviceLock());
        writer.writeIntegerValue("numberOfPastPinsRemembered", this.getNumberOfPastPinsRemembered());
        writer.writeIntegerValue("passwordMaximumAttemptCount", this.getPasswordMaximumAttemptCount());
        writer.writeIntegerValue("pinExpirationDays", this.getPinExpirationDays());
        writer.writeEnumValue("pinLowercaseLetters", (Enum)this.getPinLowercaseLetters());
        writer.writeIntegerValue("pinMinimumLength", this.getPinMinimumLength());
        writer.writeEnumValue("pinSpecialCharacters", (Enum)this.getPinSpecialCharacters());
        writer.writeEnumValue("pinUppercaseLetters", (Enum)this.getPinUppercaseLetters());
        writer.writeBooleanValue("revokeOnMdmHandoffDisabled", this.getRevokeOnMdmHandoffDisabled());
        writer.writeBooleanValue("windowsHelloForBusinessBlocked", this.getWindowsHelloForBusinessBlocked());
    }

    public void setDaysWithoutContactBeforeUnenroll(@Nullable Integer value) {
        this.backingStore.set("daysWithoutContactBeforeUnenroll", (Object)value);
    }

    public void setMdmEnrollmentUrl(@Nullable String value) {
        this.backingStore.set("mdmEnrollmentUrl", (Object)value);
    }

    public void setMinutesOfInactivityBeforeDeviceLock(@Nullable Integer value) {
        this.backingStore.set("minutesOfInactivityBeforeDeviceLock", (Object)value);
    }

    public void setNumberOfPastPinsRemembered(@Nullable Integer value) {
        this.backingStore.set("numberOfPastPinsRemembered", (Object)value);
    }

    public void setPasswordMaximumAttemptCount(@Nullable Integer value) {
        this.backingStore.set("passwordMaximumAttemptCount", (Object)value);
    }

    public void setPinExpirationDays(@Nullable Integer value) {
        this.backingStore.set("pinExpirationDays", (Object)value);
    }

    public void setPinLowercaseLetters(@Nullable WindowsInformationProtectionPinCharacterRequirements value) {
        this.backingStore.set("pinLowercaseLetters", (Object)value);
    }

    public void setPinMinimumLength(@Nullable Integer value) {
        this.backingStore.set("pinMinimumLength", (Object)value);
    }

    public void setPinSpecialCharacters(@Nullable WindowsInformationProtectionPinCharacterRequirements value) {
        this.backingStore.set("pinSpecialCharacters", (Object)value);
    }

    public void setPinUppercaseLetters(@Nullable WindowsInformationProtectionPinCharacterRequirements value) {
        this.backingStore.set("pinUppercaseLetters", (Object)value);
    }

    public void setRevokeOnMdmHandoffDisabled(@Nullable Boolean value) {
        this.backingStore.set("revokeOnMdmHandoffDisabled", (Object)value);
    }

    public void setWindowsHelloForBusinessBlocked(@Nullable Boolean value) {
        this.backingStore.set("windowsHelloForBusinessBlocked", (Object)value);
    }
}

