/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.WindowsMalwareExecutionState;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WindowsMalwareExecutionStateCount
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WindowsMalwareExecutionStateCount() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WindowsMalwareExecutionStateCount createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsMalwareExecutionStateCount();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getDeviceCount() {
        return (Integer)this.backingStore.get("deviceCount");
    }

    @Nullable
    public WindowsMalwareExecutionState getExecutionState() {
        return (WindowsMalwareExecutionState)((Object)this.backingStore.get("executionState"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("deviceCount", n -> this.setDeviceCount(n.getIntegerValue()));
        deserializerMap.put("executionState", n -> this.setExecutionState((WindowsMalwareExecutionState)n.getEnumValue(WindowsMalwareExecutionState::forValue)));
        deserializerMap.put("lastUpdateDateTime", n -> this.setLastUpdateDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastUpdateDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdateDateTime");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("deviceCount", this.getDeviceCount());
        writer.writeEnumValue("executionState", (Enum)this.getExecutionState());
        writer.writeOffsetDateTimeValue("lastUpdateDateTime", this.getLastUpdateDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDeviceCount(@Nullable Integer value) {
        this.backingStore.set("deviceCount", (Object)value);
    }

    public void setExecutionState(@Nullable WindowsMalwareExecutionState value) {
        this.backingStore.set("executionState", (Object)value);
    }

    public void setLastUpdateDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdateDateTime", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

