/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.PhysicalAddress;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SslCertificateEntity
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SslCertificateEntity() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SslCertificateEntity createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SslCertificateEntity();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public PhysicalAddress getAddress() {
        return (PhysicalAddress)this.backingStore.get("address");
    }

    @Nullable
    public List<String> getAlternateNames() {
        return (List)this.backingStore.get("alternateNames");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCommonName() {
        return (String)this.backingStore.get("commonName");
    }

    @Nullable
    public String getEmail() {
        return (String)this.backingStore.get("email");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("address", n -> this.setAddress((PhysicalAddress)n.getObjectValue(PhysicalAddress::createFromDiscriminatorValue)));
        deserializerMap.put("alternateNames", n -> this.setAlternateNames(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("commonName", n -> this.setCommonName(n.getStringValue()));
        deserializerMap.put("email", n -> this.setEmail(n.getStringValue()));
        deserializerMap.put("givenName", n -> this.setGivenName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("organizationName", n -> this.setOrganizationName(n.getStringValue()));
        deserializerMap.put("organizationUnitName", n -> this.setOrganizationUnitName(n.getStringValue()));
        deserializerMap.put("serialNumber", n -> this.setSerialNumber(n.getStringValue()));
        deserializerMap.put("surname", n -> this.setSurname(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getGivenName() {
        return (String)this.backingStore.get("givenName");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOrganizationName() {
        return (String)this.backingStore.get("organizationName");
    }

    @Nullable
    public String getOrganizationUnitName() {
        return (String)this.backingStore.get("organizationUnitName");
    }

    @Nullable
    public String getSerialNumber() {
        return (String)this.backingStore.get("serialNumber");
    }

    @Nullable
    public String getSurname() {
        return (String)this.backingStore.get("surname");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("address", (Parsable)this.getAddress(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("alternateNames", this.getAlternateNames());
        writer.writeStringValue("commonName", this.getCommonName());
        writer.writeStringValue("email", this.getEmail());
        writer.writeStringValue("givenName", this.getGivenName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("organizationName", this.getOrganizationName());
        writer.writeStringValue("organizationUnitName", this.getOrganizationUnitName());
        writer.writeStringValue("serialNumber", this.getSerialNumber());
        writer.writeStringValue("surname", this.getSurname());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAddress(@Nullable PhysicalAddress value) {
        this.backingStore.set("address", (Object)value);
    }

    public void setAlternateNames(@Nullable List<String> value) {
        this.backingStore.set("alternateNames", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCommonName(@Nullable String value) {
        this.backingStore.set("commonName", (Object)value);
    }

    public void setEmail(@Nullable String value) {
        this.backingStore.set("email", (Object)value);
    }

    public void setGivenName(@Nullable String value) {
        this.backingStore.set("givenName", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOrganizationName(@Nullable String value) {
        this.backingStore.set("organizationName", (Object)value);
    }

    public void setOrganizationUnitName(@Nullable String value) {
        this.backingStore.set("organizationUnitName", (Object)value);
    }

    public void setSerialNumber(@Nullable String value) {
        this.backingStore.set("serialNumber", (Object)value);
    }

    public void setSurname(@Nullable String value) {
        this.backingStore.set("surname", (Object)value);
    }
}

