/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.security.Host;
import com.microsoft.graph.models.security.WhoisContact;
import com.microsoft.graph.models.security.WhoisHistoryRecord;
import com.microsoft.graph.models.security.WhoisNameserver;
import com.microsoft.graph.models.security.WhoisRecord;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WhoisBaseRecord
extends Entity
implements Parsable {
    @Nonnull
    public static WhoisBaseRecord createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.security.whoisHistoryRecord": {
                    return new WhoisHistoryRecord();
                }
                case "#microsoft.graph.security.whoisRecord": {
                    return new WhoisRecord();
                }
            }
        }
        return new WhoisBaseRecord();
    }

    @Nullable
    public WhoisContact getAbuse() {
        return (WhoisContact)this.backingStore.get("abuse");
    }

    @Nullable
    public WhoisContact getAdmin() {
        return (WhoisContact)this.backingStore.get("admin");
    }

    @Nullable
    public WhoisContact getBilling() {
        return (WhoisContact)this.backingStore.get("billing");
    }

    @Nullable
    public String getDomainStatus() {
        return (String)this.backingStore.get("domainStatus");
    }

    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("expirationDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("abuse", n -> this.setAbuse((WhoisContact)n.getObjectValue(WhoisContact::createFromDiscriminatorValue)));
        deserializerMap.put("admin", n -> this.setAdmin((WhoisContact)n.getObjectValue(WhoisContact::createFromDiscriminatorValue)));
        deserializerMap.put("billing", n -> this.setBilling((WhoisContact)n.getObjectValue(WhoisContact::createFromDiscriminatorValue)));
        deserializerMap.put("domainStatus", n -> this.setDomainStatus(n.getStringValue()));
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("firstSeenDateTime", n -> this.setFirstSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("host", n -> this.setHost((Host)n.getObjectValue(Host::createFromDiscriminatorValue)));
        deserializerMap.put("lastSeenDateTime", n -> this.setLastSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastUpdateDateTime", n -> this.setLastUpdateDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("nameservers", n -> this.setNameservers(n.getCollectionOfObjectValues(WhoisNameserver::createFromDiscriminatorValue)));
        deserializerMap.put("noc", n -> this.setNoc((WhoisContact)n.getObjectValue(WhoisContact::createFromDiscriminatorValue)));
        deserializerMap.put("rawWhoisText", n -> this.setRawWhoisText(n.getStringValue()));
        deserializerMap.put("registrant", n -> this.setRegistrant((WhoisContact)n.getObjectValue(WhoisContact::createFromDiscriminatorValue)));
        deserializerMap.put("registrar", n -> this.setRegistrar((WhoisContact)n.getObjectValue(WhoisContact::createFromDiscriminatorValue)));
        deserializerMap.put("registrationDateTime", n -> this.setRegistrationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("technical", n -> this.setTechnical((WhoisContact)n.getObjectValue(WhoisContact::createFromDiscriminatorValue)));
        deserializerMap.put("whoisServer", n -> this.setWhoisServer(n.getStringValue()));
        deserializerMap.put("zone", n -> this.setZone((WhoisContact)n.getObjectValue(WhoisContact::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getFirstSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("firstSeenDateTime");
    }

    @Nullable
    public Host getHost() {
        return (Host)this.backingStore.get("host");
    }

    @Nullable
    public OffsetDateTime getLastSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastSeenDateTime");
    }

    @Nullable
    public OffsetDateTime getLastUpdateDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdateDateTime");
    }

    @Nullable
    public List<WhoisNameserver> getNameservers() {
        return (List)this.backingStore.get("nameservers");
    }

    @Nullable
    public WhoisContact getNoc() {
        return (WhoisContact)this.backingStore.get("noc");
    }

    @Nullable
    public String getRawWhoisText() {
        return (String)this.backingStore.get("rawWhoisText");
    }

    @Nullable
    public WhoisContact getRegistrant() {
        return (WhoisContact)this.backingStore.get("registrant");
    }

    @Nullable
    public WhoisContact getRegistrar() {
        return (WhoisContact)this.backingStore.get("registrar");
    }

    @Nullable
    public OffsetDateTime getRegistrationDateTime() {
        return (OffsetDateTime)this.backingStore.get("registrationDateTime");
    }

    @Nullable
    public WhoisContact getTechnical() {
        return (WhoisContact)this.backingStore.get("technical");
    }

    @Nullable
    public String getWhoisServer() {
        return (String)this.backingStore.get("whoisServer");
    }

    @Nullable
    public WhoisContact getZone() {
        return (WhoisContact)this.backingStore.get("zone");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("abuse", (Parsable)this.getAbuse(), new Parsable[0]);
        writer.writeObjectValue("admin", (Parsable)this.getAdmin(), new Parsable[0]);
        writer.writeObjectValue("billing", (Parsable)this.getBilling(), new Parsable[0]);
        writer.writeStringValue("domainStatus", this.getDomainStatus());
        writer.writeOffsetDateTimeValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeOffsetDateTimeValue("firstSeenDateTime", this.getFirstSeenDateTime());
        writer.writeObjectValue("host", (Parsable)this.getHost(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastSeenDateTime", this.getLastSeenDateTime());
        writer.writeOffsetDateTimeValue("lastUpdateDateTime", this.getLastUpdateDateTime());
        writer.writeCollectionOfObjectValues("nameservers", this.getNameservers());
        writer.writeObjectValue("noc", (Parsable)this.getNoc(), new Parsable[0]);
        writer.writeStringValue("rawWhoisText", this.getRawWhoisText());
        writer.writeObjectValue("registrant", (Parsable)this.getRegistrant(), new Parsable[0]);
        writer.writeObjectValue("registrar", (Parsable)this.getRegistrar(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("registrationDateTime", this.getRegistrationDateTime());
        writer.writeObjectValue("technical", (Parsable)this.getTechnical(), new Parsable[0]);
        writer.writeStringValue("whoisServer", this.getWhoisServer());
        writer.writeObjectValue("zone", (Parsable)this.getZone(), new Parsable[0]);
    }

    public void setAbuse(@Nullable WhoisContact value) {
        this.backingStore.set("abuse", (Object)value);
    }

    public void setAdmin(@Nullable WhoisContact value) {
        this.backingStore.set("admin", (Object)value);
    }

    public void setBilling(@Nullable WhoisContact value) {
        this.backingStore.set("billing", (Object)value);
    }

    public void setDomainStatus(@Nullable String value) {
        this.backingStore.set("domainStatus", (Object)value);
    }

    public void setExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setFirstSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("firstSeenDateTime", (Object)value);
    }

    public void setHost(@Nullable Host value) {
        this.backingStore.set("host", (Object)value);
    }

    public void setLastSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastSeenDateTime", (Object)value);
    }

    public void setLastUpdateDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdateDateTime", (Object)value);
    }

    public void setNameservers(@Nullable List<WhoisNameserver> value) {
        this.backingStore.set("nameservers", value);
    }

    public void setNoc(@Nullable WhoisContact value) {
        this.backingStore.set("noc", (Object)value);
    }

    public void setRawWhoisText(@Nullable String value) {
        this.backingStore.set("rawWhoisText", (Object)value);
    }

    public void setRegistrant(@Nullable WhoisContact value) {
        this.backingStore.set("registrant", (Object)value);
    }

    public void setRegistrar(@Nullable WhoisContact value) {
        this.backingStore.set("registrar", (Object)value);
    }

    public void setRegistrationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("registrationDateTime", (Object)value);
    }

    public void setTechnical(@Nullable WhoisContact value) {
        this.backingStore.set("technical", (Object)value);
    }

    public void setWhoisServer(@Nullable String value) {
        this.backingStore.set("whoisServer", (Object)value);
    }

    public void setZone(@Nullable WhoisContact value) {
        this.backingStore.set("zone", (Object)value);
    }
}

