/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.storage.filestorage.containers.item.drive.items.item.invite;

import com.microsoft.graph.models.DriveRecipient;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class InvitePostRequestBody
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public InvitePostRequestBody() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static InvitePostRequestBody createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new InvitePostRequestBody();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getExpirationDateTime() {
        return (String)this.backingStore.get("expirationDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getStringValue()));
        deserializerMap.put("message", n -> this.setMessage(n.getStringValue()));
        deserializerMap.put("password", n -> this.setPassword(n.getStringValue()));
        deserializerMap.put("recipients", n -> this.setRecipients(n.getCollectionOfObjectValues(DriveRecipient::createFromDiscriminatorValue)));
        deserializerMap.put("requireSignIn", n -> this.setRequireSignIn(n.getBooleanValue()));
        deserializerMap.put("retainInheritedPermissions", n -> this.setRetainInheritedPermissions(n.getBooleanValue()));
        deserializerMap.put("roles", n -> this.setRoles(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("sendInvitation", n -> this.setSendInvitation(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public String getMessage() {
        return (String)this.backingStore.get("message");
    }

    @Nullable
    public String getPassword() {
        return (String)this.backingStore.get("password");
    }

    @Nullable
    public List<DriveRecipient> getRecipients() {
        return (List)this.backingStore.get("recipients");
    }

    @Nullable
    public Boolean getRequireSignIn() {
        return (Boolean)this.backingStore.get("requireSignIn");
    }

    @Nullable
    public Boolean getRetainInheritedPermissions() {
        return (Boolean)this.backingStore.get("retainInheritedPermissions");
    }

    @Nullable
    public List<String> getRoles() {
        return (List)this.backingStore.get("roles");
    }

    @Nullable
    public Boolean getSendInvitation() {
        return (Boolean)this.backingStore.get("sendInvitation");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeStringValue("message", this.getMessage());
        writer.writeStringValue("password", this.getPassword());
        writer.writeCollectionOfObjectValues("recipients", this.getRecipients());
        writer.writeBooleanValue("requireSignIn", this.getRequireSignIn());
        writer.writeBooleanValue("retainInheritedPermissions", this.getRetainInheritedPermissions());
        writer.writeCollectionOfPrimitiveValues("roles", this.getRoles());
        writer.writeBooleanValue("sendInvitation", this.getSendInvitation());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setExpirationDateTime(@Nullable String value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setMessage(@Nullable String value) {
        this.backingStore.set("message", (Object)value);
    }

    public void setPassword(@Nullable String value) {
        this.backingStore.set("password", (Object)value);
    }

    public void setRecipients(@Nullable List<DriveRecipient> value) {
        this.backingStore.set("recipients", value);
    }

    public void setRequireSignIn(@Nullable Boolean value) {
        this.backingStore.set("requireSignIn", (Object)value);
    }

    public void setRetainInheritedPermissions(@Nullable Boolean value) {
        this.backingStore.set("retainInheritedPermissions", (Object)value);
    }

    public void setRoles(@Nullable List<String> value) {
        this.backingStore.set("roles", value);
    }

    public void setSendInvitation(@Nullable Boolean value) {
        this.backingStore.set("sendInvitation", (Object)value);
    }
}

