/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.users.item.findmeetingtimes;

import com.microsoft.graph.models.AttendeeBase;
import com.microsoft.graph.models.LocationConstraint;
import com.microsoft.graph.models.TimeConstraint;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class FindMeetingTimesPostRequestBody
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public FindMeetingTimesPostRequestBody() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static FindMeetingTimesPostRequestBody createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new FindMeetingTimesPostRequestBody();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public List<AttendeeBase> getAttendees() {
        return (List)this.backingStore.get("attendees");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("attendees", n -> this.setAttendees(n.getCollectionOfObjectValues(AttendeeBase::createFromDiscriminatorValue)));
        deserializerMap.put("isOrganizerOptional", n -> this.setIsOrganizerOptional(n.getBooleanValue()));
        deserializerMap.put("locationConstraint", n -> this.setLocationConstraint((LocationConstraint)n.getObjectValue(LocationConstraint::createFromDiscriminatorValue)));
        deserializerMap.put("maxCandidates", n -> this.setMaxCandidates(n.getIntegerValue()));
        deserializerMap.put("meetingDuration", n -> this.setMeetingDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("minimumAttendeePercentage", n -> this.setMinimumAttendeePercentage(n.getDoubleValue()));
        deserializerMap.put("returnSuggestionReasons", n -> this.setReturnSuggestionReasons(n.getBooleanValue()));
        deserializerMap.put("timeConstraint", n -> this.setTimeConstraint((TimeConstraint)n.getObjectValue(TimeConstraint::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsOrganizerOptional() {
        return (Boolean)this.backingStore.get("isOrganizerOptional");
    }

    @Nullable
    public LocationConstraint getLocationConstraint() {
        return (LocationConstraint)this.backingStore.get("locationConstraint");
    }

    @Nullable
    public Integer getMaxCandidates() {
        return (Integer)this.backingStore.get("maxCandidates");
    }

    @Nullable
    public PeriodAndDuration getMeetingDuration() {
        return (PeriodAndDuration)this.backingStore.get("meetingDuration");
    }

    @Nullable
    public Double getMinimumAttendeePercentage() {
        return (Double)this.backingStore.get("minimumAttendeePercentage");
    }

    @Nullable
    public Boolean getReturnSuggestionReasons() {
        return (Boolean)this.backingStore.get("returnSuggestionReasons");
    }

    @Nullable
    public TimeConstraint getTimeConstraint() {
        return (TimeConstraint)this.backingStore.get("timeConstraint");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("attendees", this.getAttendees());
        writer.writeBooleanValue("isOrganizerOptional", this.getIsOrganizerOptional());
        writer.writeObjectValue("locationConstraint", (Parsable)this.getLocationConstraint(), new Parsable[0]);
        writer.writeIntegerValue("maxCandidates", this.getMaxCandidates());
        writer.writePeriodAndDurationValue("meetingDuration", this.getMeetingDuration());
        writer.writeDoubleValue("minimumAttendeePercentage", this.getMinimumAttendeePercentage());
        writer.writeBooleanValue("returnSuggestionReasons", this.getReturnSuggestionReasons());
        writer.writeObjectValue("timeConstraint", (Parsable)this.getTimeConstraint(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAttendees(@Nullable List<AttendeeBase> value) {
        this.backingStore.set("attendees", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIsOrganizerOptional(@Nullable Boolean value) {
        this.backingStore.set("isOrganizerOptional", (Object)value);
    }

    public void setLocationConstraint(@Nullable LocationConstraint value) {
        this.backingStore.set("locationConstraint", (Object)value);
    }

    public void setMaxCandidates(@Nullable Integer value) {
        this.backingStore.set("maxCandidates", (Object)value);
    }

    public void setMeetingDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("meetingDuration", (Object)value);
    }

    public void setMinimumAttendeePercentage(@Nullable Double value) {
        this.backingStore.set("minimumAttendeePercentage", (Object)value);
    }

    public void setReturnSuggestionReasons(@Nullable Boolean value) {
        this.backingStore.set("returnSuggestionReasons", (Object)value);
    }

    public void setTimeConstraint(@Nullable TimeConstraint value) {
        this.backingStore.set("timeConstraint", (Object)value);
    }
}

