/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.authentication;

import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;

public class BasicAccessAuthenticationProvider
implements AuthenticationProvider {
    private static final String AUTHORIZATION_HEADER_KEY = "Authorization";
    private static final String BASIC = "Basic ";
    private final String username;
    private final String password;
    private final String encoded;

    public BasicAccessAuthenticationProvider(@Nonnull String username, @Nonnull String password) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        this.username = username;
        this.password = password;
        this.encoded = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void authenticateRequest(@Nonnull RequestInformation request, @Nullable Map<String, Object> additionalAuthenticationContext) {
        request.headers.add(AUTHORIZATION_HEADER_KEY, BASIC + this.encoded);
    }
}

