/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Pattern;

public class SerializationWriterFactoryRegistry
implements SerializationWriterFactory {
    public static final SerializationWriterFactoryRegistry defaultInstance = new SerializationWriterFactoryRegistry();
    @Nonnull
    public final HashMap<String, SerializationWriterFactory> contentTypeAssociatedFactories = new HashMap();
    private static final Pattern contentTypeVendorCleanupPattern = Pattern.compile("[^/]+\\+", 2);

    @Override
    @Nonnull
    public String getValidContentType() {
        throw new UnsupportedOperationException("The registry supports multiple content types. Get the registered factory instead.");
    }

    @Override
    @Nonnull
    public SerializationWriter getSerializationWriter(@Nonnull String contentType) {
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        String vendorSpecificContentType = contentType.split(";")[0];
        if (this.contentTypeAssociatedFactories.containsKey(vendorSpecificContentType)) {
            return this.contentTypeAssociatedFactories.get(vendorSpecificContentType).getSerializationWriter(vendorSpecificContentType);
        }
        String cleanedContentType = contentTypeVendorCleanupPattern.matcher(vendorSpecificContentType).replaceAll("");
        if (this.contentTypeAssociatedFactories.containsKey(cleanedContentType)) {
            return this.contentTypeAssociatedFactories.get(cleanedContentType).getSerializationWriter(cleanedContentType);
        }
        throw new RuntimeException("Content type " + contentType + " does not have a factory to be serialized");
    }
}

