/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.google.drive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.DriveRequest;
import com.google.api.services.drive.model.App;
import com.google.api.services.drive.model.Revision;
import com.google.api.services.drive.model.RevisionList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ExtendedBlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.blob.apps.AppLink;
import org.nuxeo.ecm.core.blob.apps.LinkedAppsProvider;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.liveconnect.google.drive.GoogleOAuth2ServiceProvider;
import org.nuxeo.ecm.liveconnect.google.drive.credential.CredentialFactory;
import org.nuxeo.ecm.liveconnect.google.drive.credential.OAuth2CredentialFactory;
import org.nuxeo.ecm.liveconnect.google.drive.credential.ServiceAccountCredentialFactory;
import org.nuxeo.ecm.liveconnect.update.BatchUpdateBlobProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class GoogleDriveBlobProvider
implements ExtendedBlobProvider,
BatchUpdateBlobProvider,
LinkedAppsProvider {
    private static final String GOOGLEDRIVE_DOCUMENT_TO_BE_UPDATED_PP = "googledrive_document_to_be_updated";
    private static final Log log = LogFactory.getLog(GoogleDriveBlobProvider.class);
    public static final String PREFIX = "googledrive";
    private static final String APPLICATION_NAME = "Nuxeo/0";
    private static final String FILE_CACHE_NAME = "googleDrive";
    public static final String SERVICE_ACCOUNT_ID_PROP = "serviceAccountId";
    public static final String SERVICE_ACCOUNT_P12_PATH_PROP = "serviceAccountP12Path";
    public static final String CLIENT_ID_PROP = "clientId";
    public static final String DEFAULT_EXPORT_MIMETYPE = "application/pdf";
    protected static final ObjectParser JSON_PARSER = new JsonObjectParser((JsonFactory)JacksonFactory.getDefaultInstance());
    private String serviceAccountId;
    private File serviceAccountP12File;
    private String clientId;
    private Cache cache;

    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        if (!PREFIX.equals(blobProviderId)) {
            throw new IllegalArgumentException("Must be registered for name: googledrive, not: " + blobProviderId);
        }
        this.serviceAccountId = properties.get(SERVICE_ACCOUNT_ID_PROP);
        if (StringUtils.isBlank((String)this.serviceAccountId)) {
            return;
        }
        String p12 = properties.get(SERVICE_ACCOUNT_P12_PATH_PROP);
        if (StringUtils.isBlank((String)p12)) {
            throw new NuxeoException("Missing value for property: serviceAccountP12Path");
        }
        this.serviceAccountP12File = new File(p12);
        if (!this.serviceAccountP12File.exists()) {
            throw new NuxeoException("No such file: " + p12 + " for property: " + SERVICE_ACCOUNT_P12_PATH_PROP);
        }
        this.clientId = properties.get(CLIENT_ID_PROP);
        if (StringUtils.isBlank((String)this.clientId)) {
            throw new NuxeoException("Missing value for property: clientId");
        }
    }

    public void close() {
    }

    public Blob readBlob(BlobManager.BlobInfo blobInfo) {
        return new SimpleManagedBlob(blobInfo);
    }

    public String writeBlob(Blob blob, Document doc) {
        throw new UnsupportedOperationException("Writing a blob to Google Drive is not supported");
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage) throws IOException {
        String url = null;
        switch (usage) {
            case STREAM: {
                url = this.getStreamUrl(blob);
                break;
            }
            case DOWNLOAD: {
                url = this.getDownloadUrl(blob);
                break;
            }
            case VIEW: 
            case EDIT: {
                url = this.getAlternateUrl(blob);
                break;
            }
            case EMBED: {
                url = this.getEmbedUrl(blob);
            }
        }
        return url == null ? null : GoogleDriveBlobProvider.asURI(url);
    }

    public Map<String, URI> getAvailableConversions(ManagedBlob blob, BlobManager.UsageHint hint) throws IOException {
        Map<String, String> exportLinks = this.getExportLinks(blob);
        if (exportLinks == null) {
            return Collections.emptyMap();
        }
        HashMap<String, URI> conversions = new HashMap<String, URI>();
        for (String mimeType : exportLinks.keySet()) {
            conversions.put(mimeType, GoogleDriveBlobProvider.asURI(exportLinks.get(mimeType)));
        }
        return conversions;
    }

    public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        String url = this.getThumbnailUrl(blob);
        return this.getStream(blob, GoogleDriveBlobProvider.asURI(url));
    }

    protected String getStreamUrl(ManagedBlob blob) throws IOException {
        FileInfo fileInfo = this.getFileInfo(blob);
        if (fileInfo.revisionId == null) {
            com.google.api.services.drive.model.File file = this.getFile(fileInfo);
            return file.getDownloadUrl();
        }
        Revision revision = this.getRevision(fileInfo);
        return revision.getDownloadUrl();
    }

    protected String getDownloadUrl(ManagedBlob blob) throws IOException {
        FileInfo fileInfo = this.getFileInfo(blob);
        if (fileInfo.revisionId == null) {
            com.google.api.services.drive.model.File file = this.getFile(fileInfo);
            String url = file.getWebContentLink();
            if (url == null) {
                url = file.getAlternateLink();
            }
            return url;
        }
        Revision revision = this.getRevision(fileInfo);
        String url = revision.getDownloadUrl();
        if (StringUtils.isBlank((String)url)) {
            url = (String)revision.getExportLinks().get(DEFAULT_EXPORT_MIMETYPE);
        }
        if (url.endsWith("&gd=true")) {
            url = url.substring(0, url.length() - "&gd=true".length());
        }
        return url;
    }

    protected String getAlternateUrl(ManagedBlob blob) throws IOException {
        FileInfo fileInfo = this.getFileInfo(blob);
        com.google.api.services.drive.model.File file = this.getFile(fileInfo);
        return file.getAlternateLink();
    }

    protected String getEmbedUrl(ManagedBlob blob) throws IOException {
        FileInfo fileInfo = this.getFileInfo(blob);
        com.google.api.services.drive.model.File file = this.getFile(fileInfo);
        String url = file.getEmbedLink();
        if (url == null) {
            url = file.getAlternateLink();
            url = GoogleDriveBlobProvider.asURI(url).resolve("./preview").toString();
        }
        return url;
    }

    protected String getThumbnailUrl(ManagedBlob blob) throws IOException {
        FileInfo fileInfo = this.getFileInfo(blob);
        com.google.api.services.drive.model.File file = this.getFile(fileInfo);
        return file.getThumbnailLink();
    }

    protected Map<String, String> getExportLinks(ManagedBlob blob) throws IOException {
        FileInfo fileInfo = this.getFileInfo(blob);
        if (fileInfo.revisionId == null) {
            com.google.api.services.drive.model.File file = this.getFile(fileInfo);
            return file.getExportLinks();
        }
        Revision revision = this.getRevision(fileInfo);
        return revision.getExportLinks();
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        URI uri = this.getURI(blob, BlobManager.UsageHint.STREAM);
        return uri == null ? null : this.getStream(blob, uri);
    }

    public InputStream getConvertedStream(ManagedBlob blob, String mimeType) throws IOException {
        Map<String, URI> conversions = this.getAvailableConversions(blob, BlobManager.UsageHint.STREAM);
        URI uri = conversions.get(mimeType);
        if (uri == null) {
            return null;
        }
        return this.getStream(blob, uri);
    }

    protected InputStream getStream(ManagedBlob blob, URI uri) throws IOException {
        FileInfo fileInfo = this.getFileInfo(blob);
        return this.doGet(fileInfo.user, uri);
    }

    public List<AppLink> getAppLinks(String username, ManagedBlob blob) throws IOException {
        ArrayList<AppLink> appLinks = new ArrayList<AppLink>();
        FileInfo fileInfo = this.getFileInfo(blob);
        String user = this.getServiceUser(username);
        com.google.api.services.drive.model.File file = this.getPartialFile(user, fileInfo.fileId, "openWithLinks", "defaultOpenWithLink");
        if (file.isEmpty()) {
            return appLinks;
        }
        String defaultLink = file.getDefaultOpenWithLink();
        for (Map.Entry entry : file.getOpenWithLinks().entrySet()) {
            App app = this.getApp(user, (String)entry.getKey());
            AppLink appLink = new AppLink();
            appLink.setAppName(app.getName());
            appLink.setLink((String)entry.getValue());
            for (App.Icons icon : app.getIcons()) {
                if (!"application".equals(icon.getCategory())) continue;
                appLink.setIcon(icon.getIconUrl());
                if (icon.getSize() != 16) continue;
                break;
            }
            if (defaultLink != null && defaultLink.equals(entry.getValue())) {
                appLinks.add(0, appLink);
                continue;
            }
            appLinks.add(appLink);
        }
        return appLinks;
    }

    protected String getServiceUser(String username) {
        CredentialFactory credentialFactory = this.getCredentialFactory();
        if (credentialFactory instanceof OAuth2CredentialFactory) {
            OAuth2ServiceProvider provider = ((OAuth2CredentialFactory)credentialFactory).getProvider();
            return ((GoogleOAuth2ServiceProvider)provider).getServiceUser(username);
        }
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        DocumentModel user = userManager.getUserModel(username);
        if (user == null) {
            return null;
        }
        return (String)((Object)user.getPropertyValue(userManager.getUserEmailField()));
    }

    protected App getApp(String user, String appId) throws IOException {
        String cacheKey = "app_" + appId;
        return this.executeAndCache(cacheKey, (DriveRequest)this.getService(user).apps().get(appId), (Class)App.class);
    }

    public ManagedBlob freezeVersion(ManagedBlob blob) throws IOException {
        FileInfo fileInfo = this.getFileInfo(blob);
        if (fileInfo.revisionId != null) {
            return null;
        }
        String user = fileInfo.user;
        String fileId = fileInfo.fileId;
        com.google.api.services.drive.model.File file = this.getFile(fileInfo);
        String revisionId = file.getHeadRevisionId();
        if (revisionId != null) {
            fileInfo = new FileInfo(user, fileId, revisionId);
            Revision revision = this.getRevision(fileInfo);
            if (!Boolean.TRUE.equals(revision.getPinned())) {
                Revision pinRevision = new Revision();
                pinRevision.setPinned(Boolean.TRUE);
                this.getService(user).revisions().patch(fileId, revisionId, pinRevision).executeUnparsed().ignore();
            }
        } else {
            List list = this.getRevisionList(fileInfo).getItems();
            if (list.isEmpty()) {
                return null;
            }
            Revision headRevision = (Revision)list.get(list.size() - 1);
            revisionId = headRevision.getId();
            fileInfo = new FileInfo(user, fileId, revisionId);
        }
        return this.getBlob(fileInfo);
    }

    protected ManagedBlob getBlob(FileInfo fileInfo) throws IOException {
        String digest;
        String key = this.getKey(fileInfo);
        com.google.api.services.drive.model.File file = this.getFile(fileInfo);
        String filename = file.getTitle().replace("/", "-");
        BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
        blobInfo.key = key;
        blobInfo.mimeType = file.getMimeType();
        blobInfo.encoding = null;
        blobInfo.filename = filename;
        blobInfo.length = file.getFileSize();
        blobInfo.digest = digest = this.getDigest(file);
        return new SimpleManagedBlob(blobInfo);
    }

    protected String getDigest(com.google.api.services.drive.model.File file) {
        String digest = file.getMd5Checksum();
        if (digest == null) {
            digest = file.getEtag();
        }
        return digest;
    }

    protected boolean isDigestChanged(Blob blob, com.google.api.services.drive.model.File file) {
        String digest = blob.getDigest();
        String md5CheckSum = file.getMd5Checksum();
        String eTag = file.getEtag();
        if (md5CheckSum != null) {
            return !md5CheckSum.equals(digest);
        }
        return eTag != null && !eTag.equals(digest);
    }

    protected boolean isFilenameChanged(Blob blob, com.google.api.services.drive.model.File file) {
        return !file.getTitle().replace("/", "-").equals(blob.getFilename());
    }

    protected boolean isChanged(Blob blob, com.google.api.services.drive.model.File file) {
        return this.isFilenameChanged(blob, file) || this.isDigestChanged(blob, file);
    }

    protected String getKey(FileInfo fileInfo) {
        return "googledrive:" + fileInfo.user + ':' + fileInfo.fileId + (fileInfo.revisionId == null ? "" : ':' + fileInfo.revisionId);
    }

    protected FileInfo getFileInfo(ManagedBlob blob) {
        String key = blob.getKey();
        int colon = key.indexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException(key);
        }
        String suffix = key.substring(colon + 1);
        String[] parts = suffix.split(":");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException(key);
        }
        return new FileInfo(parts[0], parts[1], parts.length < 3 ? null : parts[2]);
    }

    protected Credential getCredential(String user) throws IOException {
        return this.getCredentialFactory().build(user);
    }

    protected CredentialFactory getCredentialFactory() {
        OAuth2ServiceProvider provider = ((OAuth2ServiceProviderRegistry)Framework.getLocalService(OAuth2ServiceProviderRegistry.class)).getProvider(PREFIX);
        if (provider != null && provider.isEnabled()) {
            return new OAuth2CredentialFactory(provider);
        }
        return new ServiceAccountCredentialFactory(this.serviceAccountId, this.serviceAccountP12File);
    }

    protected Drive getService(String user) throws IOException {
        Credential credential = this.getCredential(user);
        HttpTransport httpTransport = credential.getTransport();
        JsonFactory jsonFactory = credential.getJsonFactory();
        return new Drive.Builder(httpTransport, jsonFactory, (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
    }

    protected com.google.api.services.drive.model.File getPartialFile(String user, String fileId, String ... fields) throws IOException {
        return (com.google.api.services.drive.model.File)this.getService(user).files().get(fileId).setFields(StringUtils.join((Object[])fields, (String)",")).execute();
    }

    protected com.google.api.services.drive.model.File getFile(FileInfo fileInfo) throws IOException {
        String cacheKey = "file_" + fileInfo.fileId;
        Drive.Files.Get request = this.getService(fileInfo.user).files().get(fileInfo.fileId);
        return this.executeAndCache(cacheKey, (DriveRequest)request, (Class)com.google.api.services.drive.model.File.class);
    }

    protected Revision getRevision(FileInfo fileInfo) throws IOException {
        if (fileInfo.revisionId == null) {
            throw new NullPointerException("null revisionId for " + fileInfo.fileId);
        }
        String cacheKey = "rev_" + fileInfo.fileId + "_" + fileInfo.revisionId;
        Drive.Revisions.Get request = this.getService(fileInfo.user).revisions().get(fileInfo.fileId, fileInfo.revisionId);
        return this.executeAndCache(cacheKey, (DriveRequest)request, (Class)Revision.class);
    }

    protected <T> T executeAndCache(String cacheKey, DriveRequest<T> request, Class<T> aClass) throws IOException {
        String resource = (String)((Object)this.getCache().get(cacheKey));
        if (resource == null) {
            HttpResponse response = request.executeUnparsed();
            if (!response.isSuccessStatusCode()) {
                return null;
            }
            resource = response.parseAsString();
            if (cacheKey != null) {
                this.getCache().put(cacheKey, (Serializable)((Object)resource));
            }
        }
        return (T)JSON_PARSER.parseAndClose((Reader)new StringReader(resource), aClass);
    }

    protected RevisionList getRevisionList(FileInfo fileInfo) throws IOException {
        return (RevisionList)this.getService(fileInfo.user).revisions().list(fileInfo.fileId).execute();
    }

    protected InputStream doGet(String user, URI url) throws IOException {
        HttpResponse response = this.getService(user).getRequestFactory().buildGetRequest(new GenericUrl(url)).execute();
        return response.getContent();
    }

    protected static URI asURI(String link) {
        try {
            return new URI(link);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid URI: " + link), (Throwable)e);
            return null;
        }
    }

    protected Cache getCache() {
        if (this.cache == null) {
            this.cache = ((CacheService)Framework.getService(CacheService.class)).getCache(FILE_CACHE_NAME);
        }
        return this.cache;
    }

    public String getClientId() {
        OAuth2ServiceProvider provider = this.getOAuth2Provider();
        return provider != null && provider.isEnabled() ? provider.getClientId() : this.clientId;
    }

    protected OAuth2ServiceProvider getOAuth2Provider() {
        return ((OAuth2ServiceProviderRegistry)Framework.getLocalService(OAuth2ServiceProviderRegistry.class)).getProvider(PREFIX);
    }

    public List<DocumentModel> checkChangesAndUpdateBlob(List<DocumentModel> docs) {
        ArrayList<DocumentModel> changedDocuments = new ArrayList<DocumentModel>();
        for (DocumentModel doc : docs) {
            SimpleManagedBlob blob = (SimpleManagedBlob)doc.getProperty("content").getValue();
            FileInfo fileInfo = this.getFileInfo((ManagedBlob)blob);
            if (this.isVersion((ManagedBlob)blob)) continue;
            try {
                com.google.api.services.drive.model.File remote = this.getPartialFile(fileInfo.user, fileInfo.fileId, "id", "title", "etag", "md5Checksum");
                if (!this.isChanged((Blob)blob, remote)) continue;
                doc.setPropertyValue("content", (Serializable)((SimpleManagedBlob)this.getBlob(this.getFileInfo((ManagedBlob)blob))));
                String cacheKey = "file_" + fileInfo.fileId;
                this.getCache().invalidate(cacheKey);
                changedDocuments.add(doc);
            }
            catch (IOException e) {
                log.error((Object)("Could not update google drive document " + doc.getTitle()), (Throwable)e);
            }
        }
        return changedDocuments;
    }

    public String getPageProviderNameForUpdate() {
        return GOOGLEDRIVE_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public String getBlobPrefix() {
        return PREFIX;
    }

    public boolean isVersion(ManagedBlob blob) {
        FileInfo fileInfo = this.getFileInfo(blob);
        return fileInfo.revisionId != null;
    }

    public static class FileInfo {
        public final String user;
        public final String fileId;
        public final String revisionId;

        public FileInfo(String user, String fileId, String revisionId) {
            this.user = user;
            this.fileId = fileId;
            this.revisionId = revisionId;
        }
    }
}

