/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.google.drive;

import com.google.api.client.auth.oauth2.Credential;
import java.io.IOException;
import java.util.Locale;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.liveconnect.google.drive.GoogleDriveBlobProvider;
import org.nuxeo.ecm.liveconnect.google.drive.GoogleOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.component.file.JSFBlobUploader;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

public class GoogleDriveBlobUploader
implements JSFBlobUploader {
    private static final Log log = LogFactory.getLog(GoogleDriveBlobUploader.class);
    public static final String UPLOAD_GOOGLE_DRIVE_FACET_NAME = "uploadGoogleDrive";
    public static final String GOOGLE_DOMAIN_PROP = "nuxeo.google.domain";
    protected String clientId;

    public GoogleDriveBlobUploader() {
        try {
            this.getGoogleDriveBlobProvider();
        }
        catch (NuxeoException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getChoice() {
        return UPLOAD_GOOGLE_DRIVE_FACET_NAME;
    }

    public void hookSubComponent(UIInput parent) {
        Application app = FacesContext.getCurrentInstance().getApplication();
        ComponentUtils.initiateSubComponent((UIComponent)parent, (String)UPLOAD_GOOGLE_DRIVE_FACET_NAME, (UIComponent)app.createComponent("javax.faces.HtmlInputText"));
    }

    public void encodeBeginUpload(UIInput parent, FacesContext context, String onClick) throws IOException {
        UIComponent facet = parent.getFacet(UPLOAD_GOOGLE_DRIVE_FACET_NAME);
        if (!(facet instanceof HtmlInputText)) {
            return;
        }
        HtmlInputText inputText = (HtmlInputText)facet;
        ResponseWriter writer = context.getResponseWriter();
        String inputId = facet.getClientId(context);
        String prefix = parent.getClientId(context) + ':';
        String pickId = prefix + "GoogleDrivePickMsg";
        String authId = prefix + "GoogleDriveAuthMsg";
        String infoId = prefix + "GoogleDriveInfo";
        String authorizationUrl = this.hasServiceAccount() ? "" : this.getOAuthAuthorizationUrl();
        Locale locale = context.getViewRoot().getLocale();
        writer.startElement("button", (UIComponent)parent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"button GoogleDrivePickerButton", null);
        String onButtonClick = onClick + ";" + String.format("new nuxeo.utils.GoogleDrivePicker('%s','%s','%s','%s','%s','%s', '%s')", this.getClientId(), pickId, authId, inputId, infoId, this.getGoogleDomain(), authorizationUrl);
        writer.writeAttribute("onclick", (Object)onButtonClick, null);
        writer.startElement("span", (UIComponent)parent);
        writer.writeAttribute("id", (Object)pickId, null);
        String message = I18NUtils.getMessageString((String)"messages", (String)"label.inputFile.googleDriveUploadPicker", null, (Locale)locale);
        writer.write(message);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)parent);
        writer.writeAttribute("id", (Object)authId, null);
        writer.writeAttribute("style", (Object)"display:none", null);
        message = I18NUtils.getMessageString((String)"messages", (String)"label.inputFile.authenticate", null, (Locale)locale);
        writer.write(message);
        writer.endElement("span");
        writer.endElement("button");
        writer.write("&#x0020;");
        writer.startElement("span", (UIComponent)parent);
        writer.writeAttribute("id", (Object)infoId, null);
        message = I18NUtils.getMessageString((String)"messages", (String)"error.inputFile.noFileSelected", null, (Locale)locale);
        writer.write(message);
        writer.endElement("span");
        inputText.setLocalValueSet(false);
        inputText.setStyle("display:none");
        ComponentUtils.encodeComponent((FacesContext)context, (UIComponent)inputText);
    }

    public void validateUpload(UIInput parent, FacesContext context, InputFileInfo submitted) {
        UIComponent facet = parent.getFacet(UPLOAD_GOOGLE_DRIVE_FACET_NAME);
        if (!(facet instanceof HtmlInputText)) {
            return;
        }
        HtmlInputText inputText = (HtmlInputText)facet;
        Object value = inputText.getSubmittedValue();
        if (value != null && !(value instanceof String)) {
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.invalidSpecialBlob");
            parent.setValid(false);
            return;
        }
        String string = (String)value;
        if (StringUtils.isBlank((String)string) || string.indexOf(58) < 0) {
            String message = context.getPartialViewContext().isAjaxRequest() ? "error.inputFile.ajax" : "error.inputFile.invalidFile";
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)message);
            parent.setValid(false);
            return;
        }
        String[] parts = string.split(":");
        String user = parts[0];
        String fileId = parts[1];
        String accessToken = this.getAccessToken(user);
        if (accessToken == null) {
            String link = String.format("<a href='#' onclick=\"openPopup('%s'); return false;\">Register a new token</a> and try again.", this.getOAuthAuthorizationUrl());
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.accessToken", (Object[])new Object[]{user, link});
            parent.setValid(false);
            return;
        }
        Blob blob = this.createBlob(new GoogleDriveBlobProvider.FileInfo(user, fileId, null));
        submitted.setBlob((Object)blob);
        submitted.setFilename((Object)blob.getFilename());
        submitted.setMimeType((Object)blob.getMimeType());
    }

    protected Blob createBlob(GoogleDriveBlobProvider.FileInfo fileInfo) {
        try {
            return this.getGoogleDriveBlobProvider().getBlob(fileInfo);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected GoogleDriveBlobProvider getGoogleDriveBlobProvider() {
        return (GoogleDriveBlobProvider)((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider("googledrive");
    }

    protected String getGoogleDomain() {
        String domain = Framework.getProperty((String)GOOGLE_DOMAIN_PROP);
        return domain != null ? domain : "";
    }

    protected String getClientId() {
        String clientId = this.getGoogleDriveBlobProvider().getClientId();
        return clientId != null ? clientId : "";
    }

    protected String getAccessToken(String user) {
        try {
            String accessToken;
            Credential credential = this.getGoogleDriveBlobProvider().getCredential(user);
            if (credential != null && (accessToken = credential.getAccessToken()) != null) {
                return accessToken;
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to get access token for " + user), (Throwable)e);
        }
        return null;
    }

    private boolean hasServiceAccount() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String username = request.getUserPrincipal().getName();
        GoogleOAuth2ServiceProvider provider = (GoogleOAuth2ServiceProvider)this.getGoogleDriveBlobProvider().getOAuth2Provider();
        return provider != null && provider.getServiceUser(username) != null;
    }

    private String getOAuthAuthorizationUrl() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        GoogleOAuth2ServiceProvider provider = (GoogleOAuth2ServiceProvider)this.getGoogleDriveBlobProvider().getOAuth2Provider();
        return provider != null && provider.getClientId() != null ? provider.getAuthorizationUrl(request) : "";
    }
}

