/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.google.drive;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.oauth2.providers.AbstractOAuth2UserEmailProvider;

public class GoogleOAuth2ServiceProvider
extends AbstractOAuth2UserEmailProvider {
    protected static final Log log = LogFactory.getLog(GoogleOAuth2ServiceProvider.class);
    private static final String TOKEN_INFO_URL = "https://www.googleapis.com/oauth2/v1/tokeninfo";
    private static final HttpRequestFactory requestFactory = HTTP_TRANSPORT.createRequestFactory(request -> request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY)));

    protected String getUserEmail(String accessToken) throws IOException {
        GenericUrl url = new GenericUrl(TOKEN_INFO_URL);
        url.set("access_token", (Object)accessToken);
        HttpResponse response = requestFactory.buildGetRequest(url).execute();
        GenericJson json = (GenericJson)response.parseAs(GenericJson.class);
        return (String)json.get((Object)"email");
    }

    public String getServiceUser(String username) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("serviceName", this.serviceName);
        filter.put("nuxeoLogin", username);
        DocumentModelList entries = this.getCredentialDataStore().query(filter);
        if (entries == null || entries.size() == 0) {
            return null;
        }
        if (entries.size() > 1) {
            log.error((Object)("Found multiple " + this.serviceName + " accounts for " + username));
        }
        return (String)((DocumentModel)entries.get(0)).getProperty("oauth2Token", "serviceLogin");
    }
}

