/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.dropbox;

import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxThumbnailFormat;
import com.dropbox.core.DbxThumbnailSize;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.liveconnect.dropbox.DropboxOAuth2ServiceProvider;
import org.nuxeo.ecm.liveconnect.dropbox.OAuthCredentialFactory;
import org.nuxeo.ecm.liveconnect.update.BatchUpdateBlobProvider;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;

public class DropboxBlobProvider
implements BlobProvider,
BatchUpdateBlobProvider {
    private static final Log log = LogFactory.getLog(DropboxBlobProvider.class);
    public static final String PREFIX = "dropbox";
    private static final String APPLICATION_NAME = "Nuxeo/0";
    private static final String FILE_CACHE_NAME = "dropbox";
    private static final String DROPBOX_DOCUMENT_TO_BE_UPDATED_PP = "dropbox_document_to_be_updated";
    private Cache fileCache;

    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
    }

    public void close() {
    }

    public Blob readBlob(BlobManager.BlobInfo blobInfo) throws IOException {
        return new SimpleManagedBlob(blobInfo);
    }

    public boolean supportsWrite() {
        return false;
    }

    public String writeBlob(Blob blob, Document doc) {
        throw new UnsupportedOperationException("Writing a blob to Dropbox is not supported");
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage, HttpServletRequest servletRequest) throws IOException {
        String url = null;
        String fileInfo = this.getFileInfo(blob.getKey());
        String user = this.getUser(fileInfo);
        String filePath = this.getFilePath(fileInfo);
        DbxClient client = this.getDropboxClient(this.getCredential(user));
        try {
            switch (usage) {
                case STREAM: {
                    url = client.createTemporaryDirectUrl((String)filePath).url;
                    break;
                }
                case DOWNLOAD: {
                    url = client.createShareableUrl(filePath);
                    url = url.replace("dl=0", "dl=1");
                    break;
                }
                case VIEW: {
                    url = client.createShareableUrl(filePath);
                }
            }
        }
        catch (DbxException e) {
            throw new IOException("Failed to get Dropbox file URI " + (Object)((Object)e));
        }
        return url != null ? DropboxBlobProvider.asURI(url) : null;
    }

    protected InputStream getStream(URI uri) throws IOException {
        return this.doGet(uri);
    }

    public Map<String, URI> getAvailableConversions(ManagedBlob blob, BlobManager.UsageHint hint) throws IOException {
        return Collections.emptyMap();
    }

    public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        String fileInfo = this.getFileInfo(blob.getKey());
        String user = this.getUser(fileInfo);
        String filePath = this.getFilePath(fileInfo);
        try {
            DbxClient.Downloader downloader = this.getDropboxClient(this.getCredential(user)).startGetThumbnail(DbxThumbnailSize.w64h64, DbxThumbnailFormat.bestForFileName((String)filePath, (DbxThumbnailFormat)DbxThumbnailFormat.JPEG), filePath, null);
            if (downloader == null) {
                return null;
            }
            return downloader.body;
        }
        catch (DbxException e) {
            throw new IOException("Failed to get Dropbox file thumbnail " + (Object)((Object)e));
        }
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        URI uri = this.getURI(blob, BlobManager.UsageHint.STREAM, null);
        return uri == null ? null : this.getStream(uri);
    }

    public InputStream getConvertedStream(ManagedBlob blob, String mimeType, DocumentModel doc) throws IOException {
        Map<String, URI> conversions = this.getAvailableConversions(blob, BlobManager.UsageHint.STREAM);
        URI uri = conversions.get(mimeType);
        if (uri == null) {
            return null;
        }
        return this.getStream(uri);
    }

    public ManagedBlob freezeVersion(ManagedBlob blob, Document doc) throws IOException {
        return null;
    }

    protected Blob getBlob(String fileInfo) throws IOException {
        String user = this.getUser(fileInfo);
        String filePath = this.getFilePath(fileInfo);
        DbxEntry.File file = this.getFile(user, filePath);
        String key = String.format("%s:%s:%s", "dropbox", user, filePath);
        BlobManager.BlobInfo blobInfo = new BlobManager.BlobInfo();
        blobInfo.key = key;
        blobInfo.filename = file.name;
        blobInfo.length = file.numBytes;
        blobInfo.mimeType = this.getMimetypeFromFilename(file.name);
        blobInfo.encoding = null;
        blobInfo.digest = file.rev;
        return new SimpleManagedBlob(blobInfo);
    }

    protected String getFileInfo(String key) {
        int colon = key.indexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException(key);
        }
        String fileInfo = key.substring(colon + 1);
        return fileInfo;
    }

    protected String getUser(String fileInfo) {
        return this.getFileInfoParts(fileInfo)[0];
    }

    protected String getFilePath(String fileInfo) {
        return this.getFileInfoParts(fileInfo)[1];
    }

    protected String[] getFileInfoParts(String fileInfo) {
        String[] parts = fileInfo.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException(fileInfo);
        }
        return parts;
    }

    protected Credential getCredential(String user) throws IOException {
        return this.getCredentialFactory().build(user);
    }

    protected OAuthCredentialFactory getCredentialFactory() {
        return new OAuthCredentialFactory((OAuth2ServiceProvider)this.getOAuth2Provider());
    }

    protected DbxClient getDropboxClient(Credential credential) throws IOException {
        return this.getDropboxClient(credential.getAccessToken());
    }

    protected DbxClient getDropboxClient(String accessToken) throws IOException {
        DbxRequestConfig config = new DbxRequestConfig(APPLICATION_NAME, Locale.getDefault().toString());
        return new DbxClient(config, accessToken);
    }

    protected DbxEntry.File getFile(String user, String filePath) throws IOException {
        DbxEntry.File fileResource = (DbxEntry.File)this.getFileCache().get(filePath);
        if (fileResource == null) {
            try {
                DbxEntry fileMetadata = this.getDropboxClient(this.getCredential(user)).getMetadata(filePath);
                if (fileMetadata == null) {
                    return null;
                }
                fileResource = fileMetadata.asFile();
                this.getFileCache().put(filePath, (Serializable)fileResource);
            }
            catch (DbxException e) {
                throw new IOException("Failed to get Dropbox file metadata " + (Object)((Object)e));
            }
        }
        return fileResource;
    }

    protected InputStream doGet(URI url) throws IOException {
        HttpRequestFactory requestFactory = this.getOAuth2Provider().getRequestFactory();
        HttpResponse response = requestFactory.buildGetRequest(new GenericUrl(url)).execute();
        return response.getContent();
    }

    protected static URI asURI(String link) {
        try {
            return new URI(link);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid URI: " + link), (Throwable)e);
            return null;
        }
    }

    protected String getClientId() {
        DropboxOAuth2ServiceProvider provider = this.getOAuth2Provider();
        return provider != null ? provider.getClientId() : null;
    }

    private Cache getFileCache() {
        if (this.fileCache == null) {
            this.fileCache = ((CacheService)Framework.getService(CacheService.class)).getCache("dropbox");
        }
        return this.fileCache;
    }

    protected DropboxOAuth2ServiceProvider getOAuth2Provider() {
        return (DropboxOAuth2ServiceProvider)((OAuth2ServiceProviderRegistry)Framework.getLocalService(OAuth2ServiceProviderRegistry.class)).getProvider("dropbox");
    }

    private String getMimetypeFromFilename(String filename) {
        MimetypeRegistryService mimetypeRegistryService = (MimetypeRegistryService)Framework.getLocalService(MimetypeRegistry.class);
        return mimetypeRegistryService.getMimetypeFromFilename(filename);
    }

    public List<DocumentModel> checkChangesAndUpdateBlob(List<DocumentModel> docs) {
        ArrayList<DocumentModel> changedDocuments = new ArrayList<DocumentModel>();
        for (DocumentModel doc : docs) {
            SimpleManagedBlob blob = (SimpleManagedBlob)doc.getProperty("content").getValue();
            if (blob == null || this.isVersion((ManagedBlob)blob)) continue;
            String fileInfo = this.getFileInfo(blob.key);
            String user = this.getUser(fileInfo);
            String filePath = this.getFilePath(fileInfo);
            try {
                DbxEntry.File file = this.getFileNoCache(user, filePath);
                if (!StringUtils.isBlank((CharSequence)blob.getDigest()) && blob.getDigest().equals(file.rev)) continue;
                log.trace((Object)("Updating " + blob.key));
                this.getFileCache().invalidate(filePath);
                doc.setPropertyValue("content", (Serializable)((SimpleManagedBlob)this.getBlob(fileInfo)));
                changedDocuments.add(doc);
            }
            catch (DbxException | IOException e) {
                log.error((Object)("Could not update dropbox document " + filePath), e);
            }
        }
        return changedDocuments;
    }

    protected DbxEntry.File getFileNoCache(String user, String filePath) throws DbxException, IOException {
        DbxEntry fileMetadata = this.getDropboxClient(this.getCredential(user)).getMetadata(filePath);
        if (fileMetadata == null) {
            return null;
        }
        DbxEntry.File file = fileMetadata.asFile();
        return file;
    }

    public String getPageProviderNameForUpdate() {
        return DROPBOX_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public String getBlobPrefix() {
        return "dropbox";
    }
}

