/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.dropbox;

import com.dropbox.core.DbxException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.liveconnect.dropbox.DropboxBlobProvider;
import org.nuxeo.ecm.liveconnect.dropbox.DropboxOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.component.file.JSFBlobUploader;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

public class DropboxBlobUploader
implements JSFBlobUploader {
    private static final Log log = LogFactory.getLog(DropboxBlobUploader.class);
    public static final String UPLOAD_DROPBOX_FACET_NAME = "uploadDropbox";

    public DropboxBlobUploader() {
        try {
            this.getDropboxBlobProvider();
        }
        catch (NuxeoException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getChoice() {
        return UPLOAD_DROPBOX_FACET_NAME;
    }

    public void hookSubComponent(UIInput parent) {
        Application app = FacesContext.getCurrentInstance().getApplication();
        ComponentUtils.initiateSubComponent((UIComponent)parent, (String)UPLOAD_DROPBOX_FACET_NAME, (UIComponent)app.createComponent("javax.faces.HtmlInputText"));
    }

    public void encodeBeginUpload(UIInput parent, FacesContext context, String onClick) throws IOException {
        UIComponent facet = parent.getFacet(UPLOAD_DROPBOX_FACET_NAME);
        if (!(facet instanceof HtmlInputText)) {
            return;
        }
        HtmlInputText inputText = (HtmlInputText)facet;
        ResponseWriter writer = context.getResponseWriter();
        String inputId = facet.getClientId(context);
        String prefix = parent.getClientId(context) + ':';
        String pickId = prefix + "DropboxPickMsg";
        String infoId = prefix + "DropboxInfo";
        String authorizationUrl = this.hasServiceAccount() ? "" : this.getOAuthAuthorizationUrl();
        Locale locale = context.getViewRoot().getLocale();
        boolean isProviderAvailable = this.getDropboxBlobProvider().getOAuth2Provider().isProviderAvailable();
        writer.startElement("button", (UIComponent)parent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"button", null);
        if (isProviderAvailable) {
            String onButtonClick = onClick + ";" + String.format("new nuxeo.utils.DropboxPicker('%s', '%s','%s', '%s')", inputId, infoId, authorizationUrl, this.getClientId());
            writer.writeAttribute("onclick", (Object)onButtonClick, null);
        }
        writer.startElement("span", (UIComponent)parent);
        writer.writeAttribute("id", (Object)pickId, null);
        String message = I18NUtils.getMessageString((String)"messages", (String)"label.inputFile.dropboxUploadPicker", null, (Locale)locale);
        writer.write(message);
        writer.endElement("span");
        writer.endElement("button");
        if (isProviderAvailable) {
            writer.write("&#x0020;");
            writer.startElement("span", (UIComponent)parent);
            writer.writeAttribute("id", (Object)infoId, null);
            message = I18NUtils.getMessageString((String)"messages", (String)"error.inputFile.noFileSelected", null, (Locale)locale);
            writer.write(message);
            writer.endElement("span");
        } else {
            writer.startElement("span", (UIComponent)parent);
            writer.writeAttribute("class", (Object)"processMessage completeWarning", null);
            writer.writeAttribute("style", (Object)"margin: 0 0 .5em 0; font-size: 11px; padding: 0.4em 0.5em 0.5em 2.2em; background-position-y: 0.6em", null);
            message = I18NUtils.getMessageString((String)"messages", (String)"error.dropbox.providerUnavailable", null, (Locale)locale);
            writer.write(message);
            writer.endElement("span");
        }
        inputText.setLocalValueSet(false);
        inputText.setStyle("display: none");
        ComponentUtils.encodeComponent((FacesContext)context, (UIComponent)inputText);
    }

    public void validateUpload(UIInput parent, FacesContext context, InputFileInfo submitted) {
        UIComponent facet = parent.getFacet(UPLOAD_DROPBOX_FACET_NAME);
        if (!(facet instanceof HtmlInputText)) {
            return;
        }
        HtmlInputText inputText = (HtmlInputText)facet;
        Object value = inputText.getSubmittedValue();
        if (value != null && !(value instanceof String)) {
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.invalidSpecialBlob");
            parent.setValid(false);
            return;
        }
        String string = (String)value;
        if (StringUtils.isBlank((String)string)) {
            String message = context.getPartialViewContext().isAjaxRequest() ? "error.inputFile.ajax" : "error.inputFile.invalidFile";
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)message);
            parent.setValid(false);
            return;
        }
        if (this.getDropboxBlobProvider().getOAuth2Provider() == null) {
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.dropboxInvalidConfiguration");
            parent.setValid(false);
            return;
        }
        String filePath = this.getPathFromUrl(string);
        if (StringUtils.isBlank((String)filePath)) {
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.invalidFilePath");
            parent.setValid(false);
            return;
        }
        String serviceUserId = this.getServiceUserId(filePath, FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal());
        if (StringUtils.isBlank((String)serviceUserId)) {
            String link = String.format("<a href='#' onclick=\"openPopup('%s'); return false;\">Register a new token</a> and try again.", this.getOAuthAuthorizationUrl());
            ComponentUtils.addErrorMessage((FacesContext)context, (UIComponent)parent, (String)"error.inputFile.invalidPermissions", (Object[])new Object[]{link});
            parent.setValid(false);
            return;
        }
        string = String.format("%s:%s", serviceUserId, filePath);
        Blob blob = this.createBlob(string);
        submitted.setBlob((Object)blob);
        submitted.setFilename((Object)blob.getFilename());
        submitted.setMimeType((Object)blob.getMimeType());
    }

    public boolean isEnabled() {
        return this.getDropboxBlobProvider().getOAuth2Provider().isEnabled();
    }

    protected Blob createBlob(String fileInfo) {
        try {
            return this.getDropboxBlobProvider().getBlob(fileInfo);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getClientId() {
        String clientId = this.getDropboxBlobProvider().getClientId();
        return clientId != null ? clientId : "";
    }

    protected DropboxBlobProvider getDropboxBlobProvider() {
        return (DropboxBlobProvider)((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider("dropbox");
    }

    private String getPathFromUrl(String url) {
        String pattern = "https://dl.dropboxusercontent.com/1/view/[\\w]*";
        String path = url.replaceAll(pattern, "");
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    private String getServiceUserId(String filePath, Principal principal) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("nuxeoLogin", principal.getName());
        DocumentModelList userTokens = this.getDropboxBlobProvider().getOAuth2Provider().getCredentialDataStore().query(filter);
        for (DocumentModel entry : userTokens) {
            NuxeoOAuth2Token token = new NuxeoOAuth2Token(entry);
            if (!this.hasAccessToFile(filePath, token.getAccessToken())) continue;
            return token.getServiceLogin();
        }
        return null;
    }

    private boolean hasAccessToFile(String filePath, String accessToken) {
        try {
            return this.getDropboxBlobProvider().getDropboxClient(accessToken).getMetadata(filePath) != null;
        }
        catch (DbxException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasServiceAccount() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String username = request.getUserPrincipal().getName();
        DropboxOAuth2ServiceProvider provider = this.getDropboxBlobProvider().getOAuth2Provider();
        return provider != null && provider.getServiceUser(username) != null;
    }

    private String getOAuthAuthorizationUrl() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        DropboxOAuth2ServiceProvider provider = this.getDropboxBlobProvider().getOAuth2Provider();
        return provider != null && provider.getClientId() != null ? provider.getAuthorizationUrl(request) : "";
    }
}

