/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.update;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.liveconnect.update.worker.BlobProviderDocumentsUpdateWork;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;

public interface BatchUpdateBlobProvider {
    public static final long MAX_RESULT = 50L;

    public List<DocumentModel> checkChangesAndUpdateBlob(List<DocumentModel> var1);

    public String getPageProviderNameForUpdate();

    public String getBlobProviderId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void processDocumentsUpdate() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        block3: for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CoreSession session = null;
            try {
                List nextDocumentsToBeUpdated;
                session = CoreInstance.openCoreSessionSystem((String)repositoryName);
                long offset = 0L;
                PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
                HashMap<String, Serializable> props = new HashMap<String, Serializable>();
                props.put("coreSession", (Serializable)session);
                PageProvider pp = ppService.getPageProvider(this.getPageProviderNameForUpdate(), null, null, null, props, new Object[0]);
                long maxResult = pp.getPageSize();
                do {
                    pp.setCurrentPageOffset(offset);
                    pp.refresh();
                    nextDocumentsToBeUpdated = pp.getCurrentPage();
                    if (nextDocumentsToBeUpdated.isEmpty()) continue block3;
                    ArrayList<String> docIds = new ArrayList<String>();
                    for (DocumentModel doc : nextDocumentsToBeUpdated) {
                        docIds.add(doc.getId());
                    }
                    BlobProviderDocumentsUpdateWork work = new BlobProviderDocumentsUpdateWork(this.getBlobProviderId() + ":" + repositoryName + ":" + offset, this.getBlobProviderId());
                    work.setDocuments(repositoryName, docIds);
                    workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
                    offset += maxResult;
                } while ((long)nextDocumentsToBeUpdated.size() == maxResult);
            }
            finally {
                if (session == null) continue;
                session.close();
            }
        }
    }
}

