/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.core;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractLiveConnectFile
implements LiveConnectFile {
    private static final long serialVersionUID = 1L;
    private final LiveConnectFileInfo info;
    private String mimeType;

    public AbstractLiveConnectFile(LiveConnectFileInfo info) {
        this.info = Objects.requireNonNull(info);
    }

    @Override
    public final LiveConnectFileInfo getInfo() {
        return this.info;
    }

    @Override
    public String getMimeType() {
        if (this.mimeType == null) {
            MimetypeRegistryService service = (MimetypeRegistryService)Framework.getLocalService(MimetypeRegistry.class);
            this.mimeType = service.getMimetypeFromFilename(this.getFilename());
        }
        return this.mimeType;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("mimeType", (Object)this.getMimeType());
        helper.add("encoding", (Object)this.getEncoding());
        helper.add("filename", (Object)this.getFilename());
        helper.add("fileSize", this.getFileSize());
        helper.add("digest", (Object)this.getDigest());
        helper.add("info", (Object)this.getInfo());
        return helper.toString();
    }
}

