/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.onedrive.oauth;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.nuxeo.ecm.liveconnect.onedrive.oauth.OneDriveAuthorizationCodeTokenRequest;
import org.nuxeo.ecm.liveconnect.onedrive.oauth.OneDriveCredential;

public class OneDriveAuthorizationCodeFlow
extends AuthorizationCodeFlow {
    private static final String RESOURCE_PARAMETER = "resource";
    private final Optional<String> businessResource;

    protected OneDriveAuthorizationCodeFlow(Builder builder) {
        super((AuthorizationCodeFlow.Builder)builder);
        this.businessResource = Objects.requireNonNull(builder.businessResource);
    }

    public AuthorizationCodeTokenRequest newTokenRequest(String authorizationCode) {
        OneDriveAuthorizationCodeTokenRequest tokenRequest = new OneDriveAuthorizationCodeTokenRequest(this.getTransport(), this.getJsonFactory(), new GenericUrl(this.getTokenServerEncodedUrl()), authorizationCode);
        this.businessResource.ifPresent(resourceURL -> tokenRequest.set(RESOURCE_PARAMETER, resourceURL));
        return tokenRequest.setClientAuthentication(this.getClientAuthentication()).setRequestInitializer(this.getRequestInitializer()).setScopes(this.getScopes());
    }

    public Credential loadCredential(String userId) throws IOException {
        return new OneDriveCredential(super.loadCredential(userId), this.businessResource);
    }

    public static class Builder
    extends AuthorizationCodeFlow.Builder {
        Optional<String> businessResource = Optional.empty();

        public Builder(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl) {
            super(method, transport, jsonFactory, tokenServerUrl, clientAuthentication, clientId, authorizationServerEncodedUrl);
        }

        public OneDriveAuthorizationCodeFlow build() {
            return new OneDriveAuthorizationCodeFlow(this);
        }

        public final Optional<String> getBusinessResource() {
            return this.businessResource;
        }

        public Builder setBusinessResource(Optional<String> businessResource) {
            this.businessResource = Objects.requireNonNull(businessResource);
            return this;
        }
    }
}

