/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.dropbox;

import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxThumbnailFormat;
import com.dropbox.core.DbxThumbnailSize;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.dropbox.DropboxLiveConnectFile;
import org.nuxeo.ecm.liveconnect.dropbox.DropboxOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;

public class DropboxBlobProvider
extends AbstractLiveConnectBlobProvider<DropboxOAuth2ServiceProvider> {
    private static final String APPLICATION_NAME = "Nuxeo/0";
    private static final String FILE_CACHE_NAME = "dropbox";
    private static final String DROPBOX_DOCUMENT_TO_BE_UPDATED_PP = "dropbox_document_to_be_updated";

    protected String getCacheName() {
        return FILE_CACHE_NAME;
    }

    public String getPageProviderNameForUpdate() {
        return DROPBOX_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage, HttpServletRequest servletRequest) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String filePath = fileInfo.getFileId();
        String url = null;
        DbxClient client = this.getDropboxClient(this.getCredential(fileInfo));
        try {
            switch (usage) {
                case STREAM: {
                    url = client.createTemporaryDirectUrl((String)filePath).url;
                    break;
                }
                case DOWNLOAD: {
                    url = client.createShareableUrl(filePath);
                    url = url.replace("dl=0", "dl=1");
                    break;
                }
                case VIEW: {
                    url = client.createShareableUrl(filePath);
                }
            }
        }
        catch (DbxException e) {
            throw new IOException("Failed to get Dropbox file URI " + (Object)((Object)e));
        }
        return url == null ? null : this.asURI(url);
    }

    public Map<String, URI> getAvailableConversions(ManagedBlob blob, BlobManager.UsageHint hint) throws IOException {
        return Collections.emptyMap();
    }

    public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String filePath = fileInfo.getFileId();
        try {
            DbxClient.Downloader downloader = this.getDropboxClient(this.getCredential(fileInfo)).startGetThumbnail(DbxThumbnailSize.w64h64, DbxThumbnailFormat.bestForFileName((String)filePath, (DbxThumbnailFormat)DbxThumbnailFormat.JPEG), filePath, null);
            if (downloader == null) {
                return null;
            }
            return downloader.body;
        }
        catch (DbxException e) {
            throw new IOException("Failed to get Dropbox file thumbnail " + (Object)((Object)e));
        }
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        URI uri = this.getURI(blob, BlobManager.UsageHint.STREAM, null);
        return uri == null ? null : this.doGet(uri);
    }

    public InputStream getConvertedStream(ManagedBlob blob, String mimeType, DocumentModel doc) throws IOException {
        Map<String, URI> conversions = this.getAvailableConversions(blob, BlobManager.UsageHint.STREAM);
        URI uri = conversions.get(mimeType);
        if (uri == null) {
            return null;
        }
        return this.doGet(uri);
    }

    public ManagedBlob freezeVersion(ManagedBlob blob, Document doc) throws IOException {
        return null;
    }

    protected DbxClient getDropboxClient(Credential credential) throws IOException {
        return this.getDropboxClient(credential.getAccessToken());
    }

    protected DbxClient getDropboxClient(String accessToken) throws IOException {
        DbxRequestConfig config = new DbxRequestConfig(APPLICATION_NAME, Locale.getDefault().toString());
        return new DbxClient(config, accessToken);
    }

    protected InputStream doGet(URI url) throws IOException {
        HttpRequestFactory requestFactory = ((DropboxOAuth2ServiceProvider)this.getOAuth2Provider()).getRequestFactory();
        HttpResponse response = requestFactory.buildGetRequest(new GenericUrl(url)).execute();
        return response.getContent();
    }

    protected String getClientId() {
        OAuth2ServiceProvider provider = this.getOAuth2Provider();
        return provider != null ? provider.getClientId() : null;
    }

    protected LiveConnectFile retrieveFile(LiveConnectFileInfo fileInfo) throws IOException {
        try {
            DbxEntry fileMetadata = this.getDropboxClient(this.getCredential(fileInfo)).getMetadata(fileInfo.getFileId());
            if (fileMetadata == null) {
                return null;
            }
            return new DropboxLiveConnectFile(fileInfo, fileMetadata.asFile());
        }
        catch (DbxException e) {
            throw new IOException("Failed to retrieve Dropbox file metadata", e);
        }
    }
}

