/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.core;

import java.io.IOException;
import org.codehaus.jackson.node.ObjectNode;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.runtime.api.Framework;

public class JSONLiveConnectBlobDecoder
implements JSONBlobDecoder {
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        if (!(jsonObject.has("providerId") && jsonObject.has("user") && jsonObject.has("fileId"))) {
            return null;
        }
        String providerId = jsonObject.get("providerId").getTextValue();
        BlobProvider provider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(providerId);
        if (!(provider instanceof LiveConnectBlobProvider)) {
            return null;
        }
        try {
            return ((LiveConnectBlobProvider)provider).toBlob(new LiveConnectFileInfo(jsonObject.get("user").getTextValue(), jsonObject.get("fileId").getTextValue()));
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

