/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.onedrive.oauth;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import java.io.IOException;
import java.util.Objects;
import org.nuxeo.ecm.liveconnect.onedrive.oauth.OneDriveRefreshTokenRequest;

class OneDriveCredential
extends Credential {
    private static final String RESOURCE_PARAMETER = "resource";
    private final String businessResource;

    public OneDriveCredential(Credential credential, String businessResource) {
        super(new Credential.Builder(credential.getMethod()).setTransport(credential.getTransport()).setJsonFactory(credential.getJsonFactory()).setTokenServerEncodedUrl(credential.getTokenServerEncodedUrl()).setClientAuthentication(credential.getClientAuthentication()).setRequestInitializer(credential.getRequestInitializer()).setRefreshListeners(credential.getRefreshListeners()).setClock(credential.getClock()));
        this.setAccessToken(credential.getAccessToken());
        this.setRefreshToken(credential.getRefreshToken());
        this.setExpirationTimeMilliseconds(credential.getExpirationTimeMilliseconds());
        this.businessResource = Objects.requireNonNull(businessResource);
    }

    protected TokenResponse executeRefreshToken() throws IOException {
        String refreshToken = this.getRefreshToken();
        if (refreshToken == null) {
            return null;
        }
        OneDriveRefreshTokenRequest refreshTokenRequest = new OneDriveRefreshTokenRequest(this.getTransport(), this.getJsonFactory(), new GenericUrl(this.getTokenServerEncodedUrl()), refreshToken);
        refreshTokenRequest.set(RESOURCE_PARAMETER, this.businessResource);
        return refreshTokenRequest.setClientAuthentication(this.getClientAuthentication()).setRequestInitializer(this.getRequestInitializer()).execute();
    }
}

