/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.http;

import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.http.OkHttpUtil;
import com.dropbox.core.http.SSLConfig;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;

public class OkHttpRequestor
extends HttpRequestor {
    public static final OkHttpRequestor INSTANCE = new OkHttpRequestor(OkHttpRequestor.defaultOkHttpClient());
    private final OkHttpClient client;

    private static OkHttpClient defaultOkHttpClient() {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(DEFAULT_CONNECT_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        client.setReadTimeout(DEFAULT_READ_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        client.setWriteTimeout(DEFAULT_READ_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        client.setSslSocketFactory(SSLConfig.getSSLSocketFactory());
        return client;
    }

    public OkHttpRequestor(OkHttpClient client) {
        if (client == null) {
            throw new NullPointerException("client");
        }
        OkHttpUtil.assertNotSameThreadExecutor(client.getDispatcher().getExecutorService());
        this.client = client.clone();
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    protected void configureRequest(Request.Builder request) {
    }

    protected Response interceptResponse(Response response) {
        return response;
    }

    @Override
    public HttpRequestor.Response doGet(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        Request.Builder builder = new Request.Builder().get().url(url);
        OkHttpRequestor.toOkHttpHeaders(headers, builder);
        this.configureRequest(builder);
        Response response = this.client.newCall(builder.build()).execute();
        response = this.interceptResponse(response);
        Map<String, List<String>> responseHeaders = OkHttpRequestor.fromOkHttpHeaders(response.headers());
        return new HttpRequestor.Response(response.code(), response.body().byteStream(), responseHeaders);
    }

    @Override
    public HttpRequestor.Uploader startPost(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        return this.startUpload(url, headers, "POST");
    }

    @Override
    public HttpRequestor.Uploader startPut(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        return this.startUpload(url, headers, "PUT");
    }

    private BufferedUploader startUpload(String url, Iterable<HttpRequestor.Header> headers, String method) {
        Request.Builder builder = new Request.Builder().url(url);
        OkHttpRequestor.toOkHttpHeaders(headers, builder);
        return new BufferedUploader(method, builder);
    }

    private static void toOkHttpHeaders(Iterable<HttpRequestor.Header> headers, Request.Builder builder) {
        for (HttpRequestor.Header header : headers) {
            builder.addHeader(header.getKey(), header.getValue());
        }
    }

    private static Map<String, List<String>> fromOkHttpHeaders(Headers headers) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>(headers.size());
        for (String name : headers.names()) {
            responseHeaders.put(name, headers.values(name));
        }
        return responseHeaders;
    }

    private static class PipedRequestBody
    extends RequestBody
    implements Closeable {
        private final OkHttpUtil.PipedStream stream = new OkHttpUtil.PipedStream();

        public OutputStream getOutputStream() {
            return this.stream.getOutputStream();
        }

        @Override
        public void close() {
            this.stream.close();
        }

        public MediaType contentType() {
            return null;
        }

        public long contentLength() {
            return -1L;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            this.stream.writeTo(sink);
            this.close();
        }
    }

    public static final class AsyncCallback
    implements Callback {
        private IOException error = null;
        private Response response = null;

        private AsyncCallback() {
        }

        public synchronized Response getResponse() throws IOException {
            while (this.error == null && this.response == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            if (this.error != null) {
                throw this.error;
            }
            return this.response;
        }

        public synchronized void onFailure(Request request, IOException ex) {
            this.error = ex;
            this.notifyAll();
        }

        public synchronized void onResponse(Response response) throws IOException {
            this.response = response;
            this.notifyAll();
        }
    }

    private class BufferedUploader
    extends HttpRequestor.Uploader {
        private final String method;
        private final Request.Builder request;
        private RequestBody body;
        private Call call;
        private AsyncCallback callback;
        private boolean closed;
        private boolean cancelled;

        public BufferedUploader(String method, Request.Builder request) {
            this.method = method;
            this.request = request;
            this.body = null;
            this.call = null;
            this.callback = null;
            this.closed = false;
            this.cancelled = false;
        }

        private void assertNoBody() {
            if (this.body != null) {
                throw new IllegalStateException("Request body already set.");
            }
        }

        @Override
        public OutputStream getBody() {
            if (this.body instanceof PipedRequestBody) {
                return ((PipedRequestBody)this.body).getOutputStream();
            }
            PipedRequestBody pipedBody = new PipedRequestBody();
            this.setBody(pipedBody);
            this.callback = new AsyncCallback();
            this.call = OkHttpRequestor.this.client.newCall(this.request.build());
            this.call.enqueue((Callback)this.callback);
            return pipedBody.getOutputStream();
        }

        private void setBody(RequestBody body) {
            this.assertNoBody();
            this.body = body;
            this.request.method(this.method, body);
            OkHttpRequestor.this.configureRequest(this.request);
        }

        @Override
        public void upload(File file) {
            this.setBody(RequestBody.create(null, (File)file));
        }

        @Override
        public void upload(byte[] body) {
            this.setBody(RequestBody.create(null, (byte[])body));
        }

        @Override
        public void close() {
            if (this.body != null && this.body instanceof Closeable) {
                try {
                    ((Closeable)this.body).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.closed = true;
        }

        @Override
        public void abort() {
            if (this.call != null) {
                this.call.cancel();
            }
            this.cancelled = true;
            this.close();
        }

        @Override
        public HttpRequestor.Response finish() throws IOException {
            Response response;
            if (this.cancelled) {
                throw new IllegalStateException("Already aborted");
            }
            if (this.body == null) {
                this.upload(new byte[0]);
            }
            if (this.callback != null) {
                try {
                    this.getBody().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                response = this.callback.getResponse();
            } else {
                this.call = OkHttpRequestor.this.client.newCall(this.request.build());
                response = this.call.execute();
            }
            response = OkHttpRequestor.this.interceptResponse(response);
            Map responseHeaders = OkHttpRequestor.fromOkHttpHeaders(response.headers());
            return new HttpRequestor.Response(response.code(), response.body().byteStream(), responseHeaders);
        }
    }
}

