/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.update.worker;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.liveconnect.update.BatchUpdateBlobProvider;
import org.nuxeo.runtime.api.Framework;

public class BlobProviderDocumentsUpdateWork
extends AbstractWork {
    private static final Log log = LogFactory.getLog(BlobProviderDocumentsUpdateWork.class);
    private static final long serialVersionUID = 1L;
    protected static final String TITLE = "Live Connect Update Documents Work";
    public static final String CATEGORY = "blobProviderDocumentsUpdate";
    protected String providerName;

    public BlobProviderDocumentsUpdateWork(String id, String providerName) {
        super(id);
        this.providerName = providerName;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getTitle() {
        return TITLE;
    }

    public void work() {
        BatchUpdateBlobProvider blobProvider = (BatchUpdateBlobProvider)((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(this.providerName);
        this.setStatus("Updating");
        if (this.session == null) {
            this.openSystemSession();
        }
        List<DocumentModel> results = this.docIds.stream().map(IdRef::new).map(arg_0 -> ((CoreSession)this.session).getDocument(arg_0)).collect(Collectors.toList());
        log.trace((Object)"Updating");
        List<DocumentModel> changedDocuments = blobProvider.checkChangesAndUpdateBlob(results);
        if (changedDocuments != null) {
            for (DocumentModel doc : changedDocuments) {
                this.session.saveDocument(doc);
            }
        }
        log.trace((Object)"Updating done");
        this.setStatus("Done");
    }
}

