/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum Visibility {
    PUBLIC,
    TEAM_ONLY,
    PASSWORD,
    TEAM_AND_PASSWORD,
    SHARED_FOLDER_ONLY,
    OTHER;


    static class Serializer
    extends UnionSerializer<Visibility> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(Visibility value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case PUBLIC: {
                    g.writeString("public");
                    break;
                }
                case TEAM_ONLY: {
                    g.writeString("team_only");
                    break;
                }
                case PASSWORD: {
                    g.writeString("password");
                    break;
                }
                case TEAM_AND_PASSWORD: {
                    g.writeString("team_and_password");
                    break;
                }
                case SHARED_FOLDER_ONLY: {
                    g.writeString("shared_folder_only");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public Visibility deserialize(JsonParser p) throws IOException, JsonParseException {
            Visibility value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("public".equals(tag)) {
                value = PUBLIC;
            } else if ("team_only".equals(tag)) {
                value = TEAM_ONLY;
            } else if ("password".equals(tag)) {
                value = PASSWORD;
            } else if ("team_and_password".equals(tag)) {
                value = TEAM_AND_PASSWORD;
            } else if ("shared_folder_only".equals(tag)) {
                value = SHARED_FOLDER_ONLY;
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

