/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.io.IOException;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveAPIException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final int responseCode;
    private final String response;

    public OneDriveAPIException(String message) {
        super(message);
        this.responseCode = -1;
        this.response = null;
    }

    public OneDriveAPIException(String message, int responseCode, String response) {
        super(message);
        this.responseCode = responseCode;
        this.response = response;
    }

    public OneDriveAPIException(String message, Throwable cause) {
        super(message, cause);
        this.responseCode = -1;
        this.response = null;
    }

    public OneDriveAPIException(String message, OneDriveRuntimeException cause) {
        super(message, cause);
        if (cause.getCause() instanceof OneDriveAPIException) {
            OneDriveAPIException subApiException = (OneDriveAPIException)cause.getCause();
            this.responseCode = subApiException.getResponseCode();
            this.response = subApiException.getResponse();
        } else {
            this.responseCode = -1;
            this.response = null;
        }
    }

    public OneDriveAPIException(String message, int responseCode, String response, Throwable cause) {
        super(message, cause);
        this.responseCode = responseCode;
        this.response = response;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponse() {
        return this.response;
    }
}

