/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveEmailAccount {
    public static String getCurrentUserEmailAccount(OneDriveAPI api) throws OneDriveAPIException {
        URL url = URLTemplate.EMPTY_TEMPLATE.build(api.getEmailURL(), new Object[0]);
        OneDriveJsonRequest request = new OneDriveJsonRequest(api, url, "GET");
        OneDriveJsonResponse response = (OneDriveJsonResponse)request.send();
        JsonObject jsonObject = response.getContent();
        if (api.isBusinessConnection()) {
            return Optional.ofNullable(jsonObject.get("Email")).filter(JsonValue::isString).map(JsonValue::asString).orElseGet(() -> OneDriveEmailAccount.searchBusinessEmail(jsonObject.get("UserProfileProperties").asArray()));
        }
        return jsonObject.get("emails").asObject().get("account").asString();
    }

    private static String searchBusinessEmail(JsonArray properties) {
        return StreamSupport.stream(properties.spliterator(), false).map(JsonValue::asObject).filter(obj -> "UserName".equals(obj.get("Key").asString())).map(obj -> obj.get("Value").asString()).findFirst().get();
    }
}

