/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.InsufficientQuotaAmounts;
import com.dropbox.core.v2.sharing.SharedFolderAccessError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class MountFolderError {
    public static final MountFolderError INSIDE_SHARED_FOLDER = new MountFolderError(Tag.INSIDE_SHARED_FOLDER, null, null);
    public static final MountFolderError ALREADY_MOUNTED = new MountFolderError(Tag.ALREADY_MOUNTED, null, null);
    public static final MountFolderError NO_PERMISSION = new MountFolderError(Tag.NO_PERMISSION, null, null);
    public static final MountFolderError NOT_MOUNTABLE = new MountFolderError(Tag.NOT_MOUNTABLE, null, null);
    public static final MountFolderError OTHER = new MountFolderError(Tag.OTHER, null, null);
    private final Tag _tag;
    private final SharedFolderAccessError accessErrorValue;
    private final InsufficientQuotaAmounts insufficientQuotaValue;

    private MountFolderError(Tag _tag, SharedFolderAccessError accessErrorValue, InsufficientQuotaAmounts insufficientQuotaValue) {
        this._tag = _tag;
        this.accessErrorValue = accessErrorValue;
        this.insufficientQuotaValue = insufficientQuotaValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static MountFolderError accessError(SharedFolderAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MountFolderError(Tag.ACCESS_ERROR, value, null);
    }

    public SharedFolderAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isInsideSharedFolder() {
        return this._tag == Tag.INSIDE_SHARED_FOLDER;
    }

    public boolean isInsufficientQuota() {
        return this._tag == Tag.INSUFFICIENT_QUOTA;
    }

    public static MountFolderError insufficientQuota(InsufficientQuotaAmounts value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MountFolderError(Tag.INSUFFICIENT_QUOTA, null, value);
    }

    public InsufficientQuotaAmounts getInsufficientQuotaValue() {
        if (this._tag != Tag.INSUFFICIENT_QUOTA) {
            throw new IllegalStateException("Invalid tag: required Tag.INSUFFICIENT_QUOTA, but was Tag." + this._tag.name());
        }
        return this.insufficientQuotaValue;
    }

    public boolean isAlreadyMounted() {
        return this._tag == Tag.ALREADY_MOUNTED;
    }

    public boolean isNoPermission() {
        return this._tag == Tag.NO_PERMISSION;
    }

    public boolean isNotMountable() {
        return this._tag == Tag.NOT_MOUNTABLE;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.accessErrorValue, this.insufficientQuotaValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MountFolderError) {
            MountFolderError other = (MountFolderError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case INSIDE_SHARED_FOLDER: {
                    return true;
                }
                case INSUFFICIENT_QUOTA: {
                    return this.insufficientQuotaValue == other.insufficientQuotaValue || this.insufficientQuotaValue.equals(other.insufficientQuotaValue);
                }
                case ALREADY_MOUNTED: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case NOT_MOUNTABLE: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MountFolderError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MountFolderError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ACCESS_ERROR: {
                    g.writeStartObject();
                    this.writeTag("access_error", g);
                    g.writeFieldName("access_error");
                    SharedFolderAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case INSIDE_SHARED_FOLDER: {
                    g.writeString("inside_shared_folder");
                    break;
                }
                case INSUFFICIENT_QUOTA: {
                    g.writeStartObject();
                    this.writeTag("insufficient_quota", g);
                    InsufficientQuotaAmounts.Serializer.INSTANCE.serialize(value.insufficientQuotaValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case ALREADY_MOUNTED: {
                    g.writeString("already_mounted");
                    break;
                }
                case NO_PERMISSION: {
                    g.writeString("no_permission");
                    break;
                }
                case NOT_MOUNTABLE: {
                    g.writeString("not_mountable");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public MountFolderError deserialize(JsonParser p) throws IOException, JsonParseException {
            MountFolderError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("access_error".equals(tag)) {
                SharedFolderAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = SharedFolderAccessError.Serializer.INSTANCE.deserialize(p);
                value = MountFolderError.accessError(fieldValue);
            } else if ("inside_shared_folder".equals(tag)) {
                value = INSIDE_SHARED_FOLDER;
            } else if ("insufficient_quota".equals(tag)) {
                InsufficientQuotaAmounts fieldValue = null;
                fieldValue = InsufficientQuotaAmounts.Serializer.INSTANCE.deserialize(p, true);
                value = MountFolderError.insufficientQuota(fieldValue);
            } else if ("already_mounted".equals(tag)) {
                value = ALREADY_MOUNTED;
            } else if ("no_permission".equals(tag)) {
                value = NO_PERMISSION;
            } else if ("not_mountable".equals(tag)) {
                value = NOT_MOUNTABLE;
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ACCESS_ERROR,
        INSIDE_SHARED_FOLDER,
        INSUFFICIENT_QUOTA,
        ALREADY_MOUNTED,
        NO_PERMISSION,
        NOT_MOUNTABLE,
        OTHER;

    }
}

