/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.FolderPolicy;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class SharedFolderMetadataBase {
    protected final AccessLevel accessType;
    protected final boolean isTeamFolder;
    protected final FolderPolicy policy;
    protected final Team ownerTeam;
    protected final String parentSharedFolderId;

    public SharedFolderMetadataBase(AccessLevel accessType, boolean isTeamFolder, FolderPolicy policy, Team ownerTeam, String parentSharedFolderId) {
        if (accessType == null) {
            throw new IllegalArgumentException("Required value for 'accessType' is null");
        }
        this.accessType = accessType;
        this.isTeamFolder = isTeamFolder;
        if (policy == null) {
            throw new IllegalArgumentException("Required value for 'policy' is null");
        }
        this.policy = policy;
        this.ownerTeam = ownerTeam;
        if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
    }

    public SharedFolderMetadataBase(AccessLevel accessType, boolean isTeamFolder, FolderPolicy policy) {
        this(accessType, isTeamFolder, policy, null, null);
    }

    public AccessLevel getAccessType() {
        return this.accessType;
    }

    public boolean getIsTeamFolder() {
        return this.isTeamFolder;
    }

    public FolderPolicy getPolicy() {
        return this.policy;
    }

    public Team getOwnerTeam() {
        return this.ownerTeam;
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public static Builder newBuilder(AccessLevel accessType, boolean isTeamFolder, FolderPolicy policy) {
        return new Builder(accessType, isTeamFolder, policy);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accessType, this.isTeamFolder, this.policy, this.ownerTeam, this.parentSharedFolderId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedFolderMetadataBase other = (SharedFolderMetadataBase)obj;
            return !(this.accessType != other.accessType && !this.accessType.equals((Object)other.accessType) || this.isTeamFolder != other.isTeamFolder || this.policy != other.policy && !this.policy.equals(other.policy) || this.ownerTeam != other.ownerTeam && (this.ownerTeam == null || !this.ownerTeam.equals(other.ownerTeam)) || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    private static class Serializer
    extends StructSerializer<SharedFolderMetadataBase> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void serialize(SharedFolderMetadataBase value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("access_type");
            AccessLevel.Serializer.INSTANCE.serialize(value.accessType, g);
            g.writeFieldName("is_team_folder");
            StoneSerializers.boolean_().serialize((Boolean)value.isTeamFolder, g);
            g.writeFieldName("policy");
            FolderPolicy.Serializer.INSTANCE.serialize(value.policy, g);
            if (value.ownerTeam != null) {
                g.writeFieldName("owner_team");
                StoneSerializers.nullable(Team.Serializer.INSTANCE).serialize(value.ownerTeam, g);
            }
            if (value.parentSharedFolderId != null) {
                g.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedFolderMetadataBase deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_parentSharedFolderId;
            Team f_ownerTeam;
            FolderPolicy f_policy;
            Boolean f_isTeamFolder;
            AccessLevel f_accessType;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accessType = null;
                f_isTeamFolder = null;
                f_policy = null;
                f_ownerTeam = null;
                f_parentSharedFolderId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("access_type".equals(field)) {
                        f_accessType = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("is_team_folder".equals(field)) {
                        f_isTeamFolder = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("policy".equals(field)) {
                        f_policy = (FolderPolicy)FolderPolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("owner_team".equals(field)) {
                        f_ownerTeam = StoneSerializers.nullable(Team.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accessType == null) {
                    throw new JsonParseException(p, "Required field \"access_type\" missing.");
                }
                if (f_isTeamFolder == null) {
                    throw new JsonParseException(p, "Required field \"is_team_folder\" missing.");
                }
                if (f_policy == null) {
                    throw new JsonParseException(p, "Required field \"policy\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedFolderMetadataBase value = new SharedFolderMetadataBase(f_accessType, f_isTeamFolder, f_policy, f_ownerTeam, f_parentSharedFolderId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final AccessLevel accessType;
        protected final boolean isTeamFolder;
        protected final FolderPolicy policy;
        protected Team ownerTeam;
        protected String parentSharedFolderId;

        protected Builder(AccessLevel accessType, boolean isTeamFolder, FolderPolicy policy) {
            if (accessType == null) {
                throw new IllegalArgumentException("Required value for 'accessType' is null");
            }
            this.accessType = accessType;
            this.isTeamFolder = isTeamFolder;
            if (policy == null) {
                throw new IllegalArgumentException("Required value for 'policy' is null");
            }
            this.policy = policy;
            this.ownerTeam = null;
            this.parentSharedFolderId = null;
        }

        public Builder withOwnerTeam(Team ownerTeam) {
            this.ownerTeam = ownerTeam;
            return this;
        }

        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
                throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
            }
            this.parentSharedFolderId = parentSharedFolderId;
            return this;
        }

        public SharedFolderMetadataBase build() {
            return new SharedFolderMetadataBase(this.accessType, this.isTeamFolder, this.policy, this.ownerTeam, this.parentSharedFolderId);
        }
    }
}

