/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveItemIterator;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveThumbnailSet;
import org.nuxeo.onedrive.client.OneDriveThumbnailSetIterator;
import org.nuxeo.onedrive.client.QueryStringBuilder;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveFolder
extends OneDriveItem
implements Iterable<OneDriveItem.Metadata> {
    private static final URLTemplate GET_FOLDER_ROOT_URL = new URLTemplate("/drive/root");
    private static final URLTemplate GET_CHILDREN_ROOT_URL = new URLTemplate("/drive/root/children");
    private static final URLTemplate SEARCH_IN_ROOT_URL = new URLTemplate("/drive/root/view.search");
    private static final URLTemplate GET_FOLDER_URL = new URLTemplate("/drive/items/%s");
    private static final URLTemplate GET_CHILDREN_URL = new URLTemplate("/drive/items/%s/children");
    private static final URLTemplate SEARCH_IN_FOLDER_URL = new URLTemplate("/drive/items/%s/view.search");

    OneDriveFolder(OneDriveAPI api) {
        super(api);
    }

    public OneDriveFolder(OneDriveAPI api, String id) {
        super(api, id);
    }

    @Override
    public Metadata getMetadata(OneDriveExpand ... expands) throws OneDriveAPIException {
        QueryStringBuilder query = new QueryStringBuilder().set("expand", expands);
        URL url = this.isRoot() ? GET_FOLDER_ROOT_URL.build(this.getApi().getBaseURL(), query, new Object[0]) : GET_FOLDER_URL.build(this.getApi().getBaseURL(), query, this.getId());
        OneDriveJsonRequest request = new OneDriveJsonRequest(this.getApi(), url, "GET");
        OneDriveJsonResponse response = (OneDriveJsonResponse)request.send();
        return new Metadata(response.getContent());
    }

    public static OneDriveFolder getRoot(OneDriveAPI api) {
        return new OneDriveFolder(api);
    }

    public Iterable<OneDriveItem.Metadata> getChildren() {
        return this;
    }

    public Iterable<OneDriveItem.Metadata> getChildren(OneDriveExpand ... expands) {
        return () -> this.iterator(expands);
    }

    @Override
    public Iterator<OneDriveItem.Metadata> iterator() {
        return this.iterator(new OneDriveExpand[0]);
    }

    public Iterator<OneDriveItem.Metadata> iterator(OneDriveExpand ... expands) {
        QueryStringBuilder query = new QueryStringBuilder().set("top", 200);
        URL url = this.isRoot() ? GET_CHILDREN_ROOT_URL.build(this.getApi().getBaseURL(), query, new Object[0]) : GET_CHILDREN_URL.build(this.getApi().getBaseURL(), query, this.getId());
        return new OneDriveItemIterator(this.getApi(), url);
    }

    public Iterable<OneDriveItem.Metadata> search(String search, OneDriveExpand ... expands) {
        QueryStringBuilder query = new QueryStringBuilder().set("q", search).set("expand", expands);
        URL url = this.isRoot() ? SEARCH_IN_ROOT_URL.build(this.getApi().getBaseURL(), query, new Object[0]) : SEARCH_IN_FOLDER_URL.build(this.getApi().getBaseURL(), query, this.getId());
        return () -> new OneDriveItemIterator(this.getApi(), url);
    }

    @Override
    public Iterable<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
        if (this.isRoot()) {
            return () -> new OneDriveThumbnailSetIterator(this.getApi());
        }
        return super.getThumbnailSets();
    }

    public class Reference
    extends OneDriveResource.Metadata {
        private String driveId;
        private String path;

        public Reference(JsonObject json) {
            super(json);
        }

        public String getDriveId() {
            return this.driveId;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("driveId".equals(memberName)) {
                    this.driveId = value.asString();
                } else if ("path".equals(memberName)) {
                    this.path = value.asString();
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException("Parse failed, maybe a bug in client.", e);
            }
        }

        @Override
        public OneDriveFolder getResource() {
            return OneDriveFolder.this;
        }
    }

    public class Metadata
    extends OneDriveItem.Metadata {
        private long childCount;

        @Override
        public List<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
            return super.getThumbnailSets();
        }

        public Metadata(JsonObject json) {
            super(json);
        }

        public long getChildCount() {
            return this.childCount;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("folder".equals(memberName)) {
                    Metadata.parseMember(value.asObject(), this::parseChildMember);
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException("Parse failed, maybe a bug in client.", e);
            }
        }

        private void parseChildMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("childCount".equals(memberName)) {
                this.childCount = value.asLong();
            }
        }

        @Override
        public OneDriveFolder getResource() {
            return OneDriveFolder.this;
        }

        @Override
        public boolean isFolder() {
            return true;
        }

        @Override
        public Metadata asFolder() {
            return this;
        }
    }
}

