/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.SharingFileAccessError;
import com.dropbox.core.v2.sharing.SharingUserError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class AddFileMemberError {
    public static final AddFileMemberError RATE_LIMIT = new AddFileMemberError(Tag.RATE_LIMIT, null, null);
    public static final AddFileMemberError INVALID_COMMENT = new AddFileMemberError(Tag.INVALID_COMMENT, null, null);
    public static final AddFileMemberError OTHER = new AddFileMemberError(Tag.OTHER, null, null);
    private final Tag _tag;
    private final SharingUserError userErrorValue;
    private final SharingFileAccessError accessErrorValue;

    private AddFileMemberError(Tag _tag, SharingUserError userErrorValue, SharingFileAccessError accessErrorValue) {
        this._tag = _tag;
        this.userErrorValue = userErrorValue;
        this.accessErrorValue = accessErrorValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUserError() {
        return this._tag == Tag.USER_ERROR;
    }

    public static AddFileMemberError userError(SharingUserError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AddFileMemberError(Tag.USER_ERROR, value, null);
    }

    public SharingUserError getUserErrorValue() {
        if (this._tag != Tag.USER_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_ERROR, but was Tag." + this._tag.name());
        }
        return this.userErrorValue;
    }

    public boolean isAccessError() {
        return this._tag == Tag.ACCESS_ERROR;
    }

    public static AddFileMemberError accessError(SharingFileAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AddFileMemberError(Tag.ACCESS_ERROR, null, value);
    }

    public SharingFileAccessError getAccessErrorValue() {
        if (this._tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this._tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isRateLimit() {
        return this._tag == Tag.RATE_LIMIT;
    }

    public boolean isInvalidComment() {
        return this._tag == Tag.INVALID_COMMENT;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.userErrorValue, this.accessErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AddFileMemberError) {
            AddFileMemberError other = (AddFileMemberError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case USER_ERROR: {
                    return this.userErrorValue == other.userErrorValue || this.userErrorValue.equals((Object)other.userErrorValue);
                }
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case RATE_LIMIT: {
                    return true;
                }
                case INVALID_COMMENT: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<AddFileMemberError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AddFileMemberError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case USER_ERROR: {
                    g.writeStartObject();
                    this.writeTag("user_error", g);
                    g.writeFieldName("user_error");
                    SharingUserError.Serializer.INSTANCE.serialize(value.userErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case ACCESS_ERROR: {
                    g.writeStartObject();
                    this.writeTag("access_error", g);
                    g.writeFieldName("access_error");
                    SharingFileAccessError.Serializer.INSTANCE.serialize(value.accessErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case RATE_LIMIT: {
                    g.writeString("rate_limit");
                    break;
                }
                case INVALID_COMMENT: {
                    g.writeString("invalid_comment");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public AddFileMemberError deserialize(JsonParser p) throws IOException, JsonParseException {
            AddFileMemberError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("user_error".equals(tag)) {
                SharingUserError fieldValue = null;
                Serializer.expectField("user_error", p);
                fieldValue = SharingUserError.Serializer.INSTANCE.deserialize(p);
                value = AddFileMemberError.userError(fieldValue);
            } else if ("access_error".equals(tag)) {
                SharingFileAccessError fieldValue = null;
                Serializer.expectField("access_error", p);
                fieldValue = SharingFileAccessError.Serializer.INSTANCE.deserialize(p);
                value = AddFileMemberError.accessError(fieldValue);
            } else if ("rate_limit".equals(tag)) {
                value = RATE_LIMIT;
            } else if ("invalid_comment".equals(tag)) {
                value = INVALID_COMMENT;
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        USER_ERROR,
        ACCESS_ERROR,
        RATE_LIMIT,
        INVALID_COMMENT,
        OTHER;

    }
}

