/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.WriteConflictError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class WriteError {
    public static final WriteError NO_WRITE_PERMISSION = new WriteError(Tag.NO_WRITE_PERMISSION, null, null);
    public static final WriteError INSUFFICIENT_SPACE = new WriteError(Tag.INSUFFICIENT_SPACE, null, null);
    public static final WriteError DISALLOWED_NAME = new WriteError(Tag.DISALLOWED_NAME, null, null);
    public static final WriteError OTHER = new WriteError(Tag.OTHER, null, null);
    private final Tag _tag;
    private final String malformedPathValue;
    private final WriteConflictError conflictValue;

    private WriteError(Tag _tag, String malformedPathValue, WriteConflictError conflictValue) {
        this._tag = _tag;
        this.malformedPathValue = malformedPathValue;
        this.conflictValue = conflictValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isMalformedPath() {
        return this._tag == Tag.MALFORMED_PATH;
    }

    public static WriteError malformedPath(String value) {
        return new WriteError(Tag.MALFORMED_PATH, value, null);
    }

    public static WriteError malformedPath() {
        return WriteError.malformedPath(null);
    }

    public String getMalformedPathValue() {
        if (this._tag != Tag.MALFORMED_PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.MALFORMED_PATH, but was Tag." + this._tag.name());
        }
        return this.malformedPathValue;
    }

    public boolean isConflict() {
        return this._tag == Tag.CONFLICT;
    }

    public static WriteError conflict(WriteConflictError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new WriteError(Tag.CONFLICT, null, value);
    }

    public WriteConflictError getConflictValue() {
        if (this._tag != Tag.CONFLICT) {
            throw new IllegalStateException("Invalid tag: required Tag.CONFLICT, but was Tag." + this._tag.name());
        }
        return this.conflictValue;
    }

    public boolean isNoWritePermission() {
        return this._tag == Tag.NO_WRITE_PERMISSION;
    }

    public boolean isInsufficientSpace() {
        return this._tag == Tag.INSUFFICIENT_SPACE;
    }

    public boolean isDisallowedName() {
        return this._tag == Tag.DISALLOWED_NAME;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.malformedPathValue, this.conflictValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WriteError) {
            WriteError other = (WriteError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case MALFORMED_PATH: {
                    return this.malformedPathValue == other.malformedPathValue || this.malformedPathValue != null && this.malformedPathValue.equals(other.malformedPathValue);
                }
                case CONFLICT: {
                    return this.conflictValue == other.conflictValue || this.conflictValue.equals((Object)other.conflictValue);
                }
                case NO_WRITE_PERMISSION: {
                    return true;
                }
                case INSUFFICIENT_SPACE: {
                    return true;
                }
                case DISALLOWED_NAME: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<WriteError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(WriteError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case MALFORMED_PATH: {
                    g.writeStartObject();
                    this.writeTag("malformed_path", g);
                    g.writeFieldName("malformed_path");
                    StoneSerializers.nullable(StoneSerializers.string()).serialize(value.malformedPathValue, g);
                    g.writeEndObject();
                    break;
                }
                case CONFLICT: {
                    g.writeStartObject();
                    this.writeTag("conflict", g);
                    g.writeFieldName("conflict");
                    WriteConflictError.Serializer.INSTANCE.serialize(value.conflictValue, g);
                    g.writeEndObject();
                    break;
                }
                case NO_WRITE_PERMISSION: {
                    g.writeString("no_write_permission");
                    break;
                }
                case INSUFFICIENT_SPACE: {
                    g.writeString("insufficient_space");
                    break;
                }
                case DISALLOWED_NAME: {
                    g.writeString("disallowed_name");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public WriteError deserialize(JsonParser p) throws IOException, JsonParseException {
            WriteError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("malformed_path".equals(tag)) {
                String fieldValue = null;
                if (p.getCurrentToken() != JsonToken.END_OBJECT) {
                    Serializer.expectField("malformed_path", p);
                    fieldValue = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                }
                value = fieldValue == null ? WriteError.malformedPath() : WriteError.malformedPath(fieldValue);
            } else if ("conflict".equals(tag)) {
                WriteConflictError fieldValue = null;
                Serializer.expectField("conflict", p);
                fieldValue = WriteConflictError.Serializer.INSTANCE.deserialize(p);
                value = WriteError.conflict(fieldValue);
            } else if ("no_write_permission".equals(tag)) {
                value = NO_WRITE_PERMISSION;
            } else if ("insufficient_space".equals(tag)) {
                value = INSUFFICIENT_SPACE;
            } else if ("disallowed_name".equals(tag)) {
                value = DISALLOWED_NAME;
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        MALFORMED_PATH,
        CONFLICT,
        NO_WRITE_PERMISSION,
        INSUFFICIENT_SPACE,
        DISALLOWED_NAME,
        OTHER;

    }
}

