/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SaveCopyReferenceError {
    public static final SaveCopyReferenceError INVALID_COPY_REFERENCE = new SaveCopyReferenceError(Tag.INVALID_COPY_REFERENCE, null);
    public static final SaveCopyReferenceError NO_PERMISSION = new SaveCopyReferenceError(Tag.NO_PERMISSION, null);
    public static final SaveCopyReferenceError NOT_FOUND = new SaveCopyReferenceError(Tag.NOT_FOUND, null);
    public static final SaveCopyReferenceError TOO_MANY_FILES = new SaveCopyReferenceError(Tag.TOO_MANY_FILES, null);
    public static final SaveCopyReferenceError OTHER = new SaveCopyReferenceError(Tag.OTHER, null);
    private final Tag _tag;
    private final WriteError pathValue;

    private SaveCopyReferenceError(Tag _tag, WriteError pathValue) {
        this._tag = _tag;
        this.pathValue = pathValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static SaveCopyReferenceError path(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SaveCopyReferenceError(Tag.PATH, value);
    }

    public WriteError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isInvalidCopyReference() {
        return this._tag == Tag.INVALID_COPY_REFERENCE;
    }

    public boolean isNoPermission() {
        return this._tag == Tag.NO_PERMISSION;
    }

    public boolean isNotFound() {
        return this._tag == Tag.NOT_FOUND;
    }

    public boolean isTooManyFiles() {
        return this._tag == Tag.TOO_MANY_FILES;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SaveCopyReferenceError) {
            SaveCopyReferenceError other = (SaveCopyReferenceError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case INVALID_COPY_REFERENCE: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case NOT_FOUND: {
                    return true;
                }
                case TOO_MANY_FILES: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SaveCopyReferenceError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SaveCopyReferenceError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g.writeStartObject();
                    this.writeTag("path", g);
                    g.writeFieldName("path");
                    WriteError.Serializer.INSTANCE.serialize(value.pathValue, g);
                    g.writeEndObject();
                    break;
                }
                case INVALID_COPY_REFERENCE: {
                    g.writeString("invalid_copy_reference");
                    break;
                }
                case NO_PERMISSION: {
                    g.writeString("no_permission");
                    break;
                }
                case NOT_FOUND: {
                    g.writeString("not_found");
                    break;
                }
                case TOO_MANY_FILES: {
                    g.writeString("too_many_files");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SaveCopyReferenceError deserialize(JsonParser p) throws IOException, JsonParseException {
            SaveCopyReferenceError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                WriteError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = WriteError.Serializer.INSTANCE.deserialize(p);
                value = SaveCopyReferenceError.path(fieldValue);
            } else if ("invalid_copy_reference".equals(tag)) {
                value = INVALID_COPY_REFERENCE;
            } else if ("no_permission".equals(tag)) {
                value = NO_PERMISSION;
            } else if ("not_found".equals(tag)) {
                value = NOT_FOUND;
            } else if ("too_many_files".equals(tag)) {
                value = TOO_MANY_FILES;
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        INVALID_COPY_REFERENCE,
        NO_PERMISSION,
        NOT_FOUND,
        TOO_MANY_FILES,
        OTHER;

    }
}

