/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.dropbox;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ThumbnailFormat;
import com.dropbox.core.v2.files.ThumbnailSize;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.dropbox.DropboxLiveConnectFile;
import org.nuxeo.ecm.liveconnect.dropbox.DropboxOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;

public class DropboxBlobProvider
extends AbstractLiveConnectBlobProvider<DropboxOAuth2ServiceProvider> {
    private static final Log log = LogFactory.getLog(DropboxBlobProvider.class);
    private static final String APPLICATION_NAME = "Nuxeo/0";
    private static final String FILE_CACHE_NAME = "dropbox";
    private static final String DROPBOX_DOCUMENT_TO_BE_UPDATED_PP = "dropbox_document_to_be_updated";

    protected String getCacheName() {
        return FILE_CACHE_NAME;
    }

    public String getPageProviderNameForUpdate() {
        return DROPBOX_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage, HttpServletRequest servletRequest) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String filePath = fileInfo.getFileId();
        String url = null;
        DbxClientV2 client = this.getDropboxClient(this.getCredential(fileInfo));
        try {
            switch (usage) {
                case STREAM: {
                    url = client.files().getTemporaryLink(filePath).getLink();
                    break;
                }
                case DOWNLOAD: {
                    url = client.files().getTemporaryLink(filePath).getLink();
                    break;
                }
                case VIEW: {
                    url = client.files().getTemporaryLink(filePath).getLink();
                }
            }
        }
        catch (DbxException e) {
            throw new IOException("Failed to get Dropbox file URI " + (Object)((Object)e));
        }
        return url == null ? null : this.asURI(url);
    }

    public Map<String, URI> getAvailableConversions(ManagedBlob blob, BlobManager.UsageHint hint) throws IOException {
        return Collections.emptyMap();
    }

    public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String filePath = fileInfo.getFileId();
        try {
            DbxDownloader downloader = this.getDropboxClient(this.getCredential(fileInfo)).files().getThumbnailBuilder(filePath).withFormat(ThumbnailFormat.JPEG).withSize(ThumbnailSize.W64H64).start();
            if (downloader == null) {
                return null;
            }
            return downloader.getInputStream();
        }
        catch (DbxException e) {
            log.warn((Object)String.format("Failed to get thumbnail for file %s", filePath), (Throwable)e);
            return null;
        }
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        URI uri = this.getURI(blob, BlobManager.UsageHint.STREAM, null);
        return uri == null ? null : this.doGet(uri);
    }

    public InputStream getConvertedStream(ManagedBlob blob, String mimeType, DocumentModel doc) throws IOException {
        Map<String, URI> conversions = this.getAvailableConversions(blob, BlobManager.UsageHint.STREAM);
        URI uri = conversions.get(mimeType);
        if (uri == null) {
            return null;
        }
        return this.doGet(uri);
    }

    public ManagedBlob freezeVersion(ManagedBlob blob, Document doc) throws IOException {
        return null;
    }

    protected DbxClientV2 getDropboxClient(Credential credential) throws IOException {
        return this.getDropboxClient(credential.getAccessToken());
    }

    protected DbxClientV2 getDropboxClient(String accessToken) throws IOException {
        DbxRequestConfig config = new DbxRequestConfig(APPLICATION_NAME, Locale.getDefault().toString());
        return new DbxClientV2(config, accessToken);
    }

    protected InputStream doGet(URI url) throws IOException {
        HttpRequestFactory requestFactory = ((DropboxOAuth2ServiceProvider)this.getOAuth2Provider()).getRequestFactory();
        HttpResponse response = requestFactory.buildGetRequest(new GenericUrl(url)).execute();
        return response.getContent();
    }

    protected String getClientId() {
        OAuth2ServiceProvider provider = this.getOAuth2Provider();
        return provider != null ? provider.getClientId() : null;
    }

    protected LiveConnectFile retrieveFile(LiveConnectFileInfo fileInfo) throws IOException {
        try {
            FileMetadata fileMetadata = (FileMetadata)this.getDropboxClient(this.getCredential(fileInfo)).files().download(fileInfo.getFileId()).getResult();
            if (fileMetadata == null) {
                return null;
            }
            return new DropboxLiveConnectFile(fileInfo, fileMetadata);
        }
        catch (DbxException e) {
            throw new IOException("Failed to retrieve Dropbox file metadata", e);
        }
    }
}

