/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import java.net.MalformedURLException;
import java.net.URL;

class QueryStringBuilder {
    private final StringBuilder stringBuilder;

    QueryStringBuilder() {
        this.stringBuilder = new StringBuilder();
    }

    QueryStringBuilder(String existing) {
        this.stringBuilder = existing == null ? new StringBuilder() : new StringBuilder(existing);
    }

    QueryStringBuilder appendParam(String key, String ... fields) {
        StringBuilder valuesBuilder = new StringBuilder();
        for (String field : fields) {
            valuesBuilder.append(field);
            valuesBuilder.append(",");
        }
        valuesBuilder.deleteCharAt(valuesBuilder.length() - 1);
        this.appendParam(key, valuesBuilder.toString());
        return this;
    }

    QueryStringBuilder appendParam(String key, String value) {
        if (this.stringBuilder.length() == 0) {
            this.stringBuilder.append('?');
        } else {
            this.stringBuilder.append('&');
        }
        this.stringBuilder.append(key);
        this.stringBuilder.append('=');
        this.stringBuilder.append(this.encode(value));
        return this;
    }

    QueryStringBuilder appendParam(String key, long value) {
        return this.appendParam(key, Long.toString(value));
    }

    URL addToURL(URL existing) throws MalformedURLException {
        String existingQuery = existing.getQuery();
        if (existingQuery == null || existingQuery.equals("")) {
            return new URL(existing.toString() + this.toString());
        }
        return new URL(existing.toString().replace(existingQuery, this.toString()));
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    private String encode(String unencoded) {
        StringBuilder encodedBuilder = new StringBuilder();
        int n = unencoded.length();
        block20: for (int i = 0; i < n; ++i) {
            char c = unencoded.charAt(i);
            switch (c) {
                case ' ': {
                    encodedBuilder.append('+');
                    continue block20;
                }
                case '!': {
                    encodedBuilder.append("%21");
                    continue block20;
                }
                case '#': {
                    encodedBuilder.append("%23");
                    continue block20;
                }
                case '$': {
                    encodedBuilder.append("%24");
                    continue block20;
                }
                case '&': {
                    encodedBuilder.append("%26");
                    continue block20;
                }
                case '\'': {
                    encodedBuilder.append("%27");
                    continue block20;
                }
                case '(': {
                    encodedBuilder.append("%28");
                    continue block20;
                }
                case ')': {
                    encodedBuilder.append("%29");
                    continue block20;
                }
                case '+': {
                    encodedBuilder.append("%2b");
                    continue block20;
                }
                case ',': {
                    encodedBuilder.append("%2c");
                    continue block20;
                }
                case '/': {
                    encodedBuilder.append("%2f");
                    continue block20;
                }
                case ':': {
                    encodedBuilder.append("%3a");
                    continue block20;
                }
                case ';': {
                    encodedBuilder.append("%3b");
                    continue block20;
                }
                case '=': {
                    encodedBuilder.append("%3d");
                    continue block20;
                }
                case '?': {
                    encodedBuilder.append("%3f");
                    continue block20;
                }
                case '@': {
                    encodedBuilder.append("%40");
                    continue block20;
                }
                case '[': {
                    encodedBuilder.append("%5b");
                    continue block20;
                }
                case ']': {
                    encodedBuilder.append("%5d");
                    continue block20;
                }
                default: {
                    encodedBuilder.append(c);
                }
            }
        }
        return encodedBuilder.toString();
    }
}

