/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum WriteConflictError {
    FILE,
    FOLDER,
    FILE_ANCESTOR,
    OTHER;


    static class Serializer
    extends UnionSerializer<WriteConflictError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(WriteConflictError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case FILE: {
                    g.writeString("file");
                    break;
                }
                case FOLDER: {
                    g.writeString("folder");
                    break;
                }
                case FILE_ANCESTOR: {
                    g.writeString("file_ancestor");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public WriteConflictError deserialize(JsonParser p) throws IOException, JsonParseException {
            WriteConflictError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("file".equals(tag)) {
                value = FILE;
            } else if ("folder".equals(tag)) {
                value = FOLDER;
            } else if ("file_ancestor".equals(tag)) {
                value = FILE_ANCESTOR;
            } else {
                value = OTHER;
                Serializer.skipFields(p);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

