/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxSharedLink;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.json.GenericJson;
import com.google.api.client.util.ArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.liveconnect.box.BoxLiveConnectFile;
import org.nuxeo.ecm.liveconnect.box.BoxOAuth2ServiceProvider;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;

public class BoxBlobProvider
extends AbstractLiveConnectBlobProvider<BoxOAuth2ServiceProvider> {
    private static final String CACHE_NAME = "box";
    private static final String BOX_DOCUMENT_TO_BE_UPDATED_PP = "box_document_to_be_updated";
    private static final String BOX_URL = "https://api.box.com/2.0/";
    private static final String DOWNLOAD_CONTENT_URL = "https://api.box.com/2.0/files/%s/content";
    private static final String THUMBNAIL_CONTENT_URL = "https://api.box.com/2.0/files/%s/thumbnail.jpg?min_height=320&min_width=320";
    private static final String EMBED_URL = "https://api.box.com/2.0/files/%s?fields=expiring_embed_link";

    protected String getCacheName() {
        return CACHE_NAME;
    }

    public String getPageProviderNameForUpdate() {
        return BOX_DOCUMENT_TO_BE_UPDATED_PP;
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint usage, HttpServletRequest servletRequest) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        String url = null;
        switch (usage) {
            case STREAM: 
            case DOWNLOAD: {
                url = this.getDownloadUrl(fileInfo);
                break;
            }
            case VIEW: {
                url = this.retrieveSharedLink(fileInfo).getURL();
                break;
            }
            case EMBED: {
                url = this.getEmbedUrl(fileInfo);
            }
        }
        return url == null ? null : this.asURI(url);
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        URI uri = this.getURI(blob, BlobManager.UsageHint.STREAM, null);
        return uri == null ? null : this.doGet(uri.toString()).getContent();
    }

    public InputStream getThumbnail(ManagedBlob blob) throws IOException {
        GenericUrl url;
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        HttpResponse response = this.executeAuthenticate(fileInfo, url = new GenericUrl(String.format(THUMBNAIL_CONTENT_URL, fileInfo.getFileId())), false);
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            return response.getContent();
        }
        if (statusCode == 302 || statusCode == 202) {
            response.disconnect();
            return this.doGet(response.getHeaders().getLocation()).getContent();
        }
        throw new HttpResponseException(response);
    }

    public ManagedBlob freezeVersion(ManagedBlob blob, Document doc) throws IOException {
        LiveConnectFileInfo fileInfo = this.toFileInfo(blob);
        if (fileInfo.getRevisionId().isPresent()) {
            return null;
        }
        BoxFile.Info boxFileInfo = this.retrieveBoxFileInfo(fileInfo);
        this.putFileInCache((LiveConnectFile)new BoxLiveConnectFile(fileInfo, boxFileInfo));
        String revisionId = boxFileInfo.getVersion().getVersionID();
        fileInfo = new LiveConnectFileInfo(fileInfo.getUser(), fileInfo.getFileId(), revisionId);
        BoxLiveConnectFile file = new BoxLiveConnectFile(fileInfo, boxFileInfo);
        return this.toBlob((LiveConnectFile)file);
    }

    protected BoxAPIConnection getBoxClient(NuxeoOAuth2Token token) throws IOException {
        return this.getBoxClient(this.getCredential(token));
    }

    protected BoxAPIConnection getBoxClient(Credential credential) throws IOException {
        return new BoxAPIConnection(credential.getAccessToken());
    }

    protected LiveConnectFile retrieveFile(LiveConnectFileInfo fileInfo) throws IOException {
        return new BoxLiveConnectFile(fileInfo, this.retrieveBoxFileInfo(fileInfo));
    }

    protected BoxFile.Info retrieveBoxFileInfo(LiveConnectFileInfo fileInfo) throws IOException {
        try {
            return this.prepareBoxFile(fileInfo).getInfo();
        }
        catch (BoxAPIException e) {
            throw new IOException("Failed to retrieve Box file metadata", e);
        }
    }

    private BoxSharedLink retrieveSharedLink(LiveConnectFileInfo fileInfo) throws IOException {
        try {
            return this.prepareBoxFile(fileInfo).createSharedLink(BoxSharedLink.Access.OPEN, null, null);
        }
        catch (BoxAPIException e) {
            throw new IOException("Failed to retrieve Box shared link", e);
        }
    }

    private BoxFile prepareBoxFile(LiveConnectFileInfo fileInfo) throws IOException {
        BoxAPIConnection boxClient = this.getBoxClient(this.getCredential(fileInfo));
        return new BoxFile(boxClient, fileInfo.getFileId());
    }

    private String getDownloadUrl(LiveConnectFileInfo fileInfo) throws IOException {
        GenericUrl url = new GenericUrl(String.format(DOWNLOAD_CONTENT_URL, fileInfo.getFileId()));
        fileInfo.getRevisionId().ifPresent(revId -> url.put("version", revId));
        HttpResponse response = this.executeAuthenticate(fileInfo, url, false);
        response.disconnect();
        if (response.getStatusCode() == 302) {
            return response.getHeaders().getLocation();
        }
        throw new HttpResponseException(response);
    }

    private String getEmbedUrl(LiveConnectFileInfo fileInfo) throws IOException {
        GenericUrl url = new GenericUrl(String.format(EMBED_URL, fileInfo.getFileId()));
        try {
            HttpResponse response = this.executeAuthenticate(fileInfo, url, true);
            GenericJson boxInfo = (GenericJson)response.parseAs(GenericJson.class);
            return ((ArrayMap)boxInfo.get((Object)"expiring_embed_link")).get((Object)"url").toString();
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 414) {
                return null;
            }
            throw e;
        }
    }

    private HttpResponse executeAuthenticate(LiveConnectFileInfo fileInfo, GenericUrl url, boolean followRedirect) throws IOException {
        Credential credential = this.getCredential(fileInfo);
        HttpRequest request = ((BoxOAuth2ServiceProvider)this.getOAuth2Provider()).getRequestFactory().buildGetRequest(url);
        request.setHeaders(new HttpHeaders().setAuthorization("Bearer " + credential.getAccessToken()));
        request.setFollowRedirects(followRedirect);
        request.setThrowExceptionOnExecuteError(followRedirect);
        return request.execute();
    }

    private HttpResponse doGet(String url) throws IOException {
        HttpRequestFactory requestFactory = ((BoxOAuth2ServiceProvider)this.getOAuth2Provider()).getRequestFactory();
        return requestFactory.buildGetRequest(new GenericUrl(url)).execute();
    }
}

