/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.MemberAddResult;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class MembersAddJobStatus {
    public static final MembersAddJobStatus IN_PROGRESS = new MembersAddJobStatus(Tag.IN_PROGRESS, null, null);
    private final Tag _tag;
    private final List<MemberAddResult> completeValue;
    private final String failedValue;

    private MembersAddJobStatus(Tag _tag, List<MemberAddResult> completeValue, String failedValue) {
        this._tag = _tag;
        this.completeValue = completeValue;
        this.failedValue = failedValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInProgress() {
        return this._tag == Tag.IN_PROGRESS;
    }

    public boolean isComplete() {
        return this._tag == Tag.COMPLETE;
    }

    public static MembersAddJobStatus complete(List<MemberAddResult> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (MemberAddResult x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new MembersAddJobStatus(Tag.COMPLETE, value, null);
    }

    public List<MemberAddResult> getCompleteValue() {
        if (this._tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this._tag.name());
        }
        return this.completeValue;
    }

    public boolean isFailed() {
        return this._tag == Tag.FAILED;
    }

    public static MembersAddJobStatus failed(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MembersAddJobStatus(Tag.FAILED, null, value);
    }

    public String getFailedValue() {
        if (this._tag != Tag.FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILED, but was Tag." + this._tag.name());
        }
        return this.failedValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.completeValue, this.failedValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MembersAddJobStatus) {
            MembersAddJobStatus other = (MembersAddJobStatus)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case IN_PROGRESS: {
                    return true;
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
                case FAILED: {
                    return this.failedValue == other.failedValue || this.failedValue.equals(other.failedValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MembersAddJobStatus> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersAddJobStatus value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case IN_PROGRESS: {
                    g.writeString("in_progress");
                    break;
                }
                case COMPLETE: {
                    g.writeStartObject();
                    this.writeTag("complete", g);
                    g.writeFieldName("complete");
                    StoneSerializers.list(MemberAddResult.Serializer.INSTANCE).serialize((List<MemberAddResult>)value.completeValue, g);
                    g.writeEndObject();
                    break;
                }
                case FAILED: {
                    g.writeStartObject();
                    this.writeTag("failed", g);
                    g.writeFieldName("failed");
                    StoneSerializers.string().serialize(value.failedValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public MembersAddJobStatus deserialize(JsonParser p) throws IOException, JsonParseException {
            MembersAddJobStatus value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("in_progress".equals(tag)) {
                value = IN_PROGRESS;
            } else if ("complete".equals(tag)) {
                List<MemberAddResult> fieldValue = null;
                Serializer.expectField("complete", p);
                fieldValue = StoneSerializers.list(MemberAddResult.Serializer.INSTANCE).deserialize(p);
                value = MembersAddJobStatus.complete(fieldValue);
            } else if ("failed".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("failed", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MembersAddJobStatus.failed(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        IN_PROGRESS,
        COMPLETE,
        FAILED;

    }
}

