/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class Dimensions {
    protected final long height;
    protected final long width;

    public Dimensions(long height, long width) {
        this.height = height;
        this.width = width;
    }

    public long getHeight() {
        return this.height;
    }

    public long getWidth() {
        return this.width;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.height, this.width});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            Dimensions other = (Dimensions)obj;
            return this.height == other.height && this.width == other.width;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<Dimensions> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(Dimensions value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("height");
            StoneSerializers.uInt64().serialize((Long)value.height, g);
            g.writeFieldName("width");
            StoneSerializers.uInt64().serialize((Long)value.width, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public Dimensions deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_width;
            Long f_height;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_height = null;
                f_width = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("height".equals(field)) {
                        f_height = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("width".equals(field)) {
                        f_width = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_height == null) {
                    throw new JsonParseException(p, "Required field \"height\" missing.");
                }
                if (f_width == null) {
                    throw new JsonParseException(p, "Required field \"width\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            Dimensions value = new Dimensions(f_height, f_width);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

